/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.sax;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugins.xml.AbstractXmlJavaGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlModelMetadata;

@Named(value="sax-writer")
public class SaxWriterGenerator
extends AbstractXmlJavaGenerator {
    private boolean requiresDomSupport;

    public void generate(Model model, Map<String, Object> parameters) throws ModelloException {
        this.initialize(model, parameters);
        this.requiresDomSupport = false;
        try {
            this.generateSaxWriter();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating SAX Writer.", (Throwable)ex);
        }
    }

    private void generateSaxWriter() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = objectModel.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion()) + ".io.sax";
        String marshallerName = this.getFileName("SaxWriter");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, marshallerName);
        JClass jClass = new JClass(packageName + '.' + marshallerName);
        this.initHeader(jClass);
        this.suppressAllWarnings(objectModel, (JStructure)jClass);
        jClass.addImport("java.io.IOException");
        jClass.addImport("java.io.OutputStream");
        jClass.addImport("java.io.OutputStreamWriter");
        jClass.addImport("java.io.UnsupportedEncodingException");
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.util.Iterator");
        jClass.addImport("java.util.Properties");
        jClass.addImport("javax.xml.transform.OutputKeys");
        jClass.addImport("javax.xml.transform.TransformerException");
        jClass.addImport("javax.xml.transform.TransformerFactory");
        jClass.addImport("javax.xml.transform.sax.SAXTransformerFactory");
        jClass.addImport("javax.xml.transform.sax.TransformerHandler");
        jClass.addImport("javax.xml.transform.stream.StreamResult");
        jClass.addImport("org.xml.sax.ContentHandler");
        jClass.addImport("org.xml.sax.SAXException");
        jClass.addImport("org.xml.sax.helpers.AttributesImpl");
        JField namespaceField = new JField((JType)new JClass("String"), "NAMESPACE");
        namespaceField.getModifiers().setFinal(true);
        namespaceField.getModifiers().setStatic(true);
        namespaceField.setInitString("\"\"");
        jClass.addField(namespaceField);
        JField factoryField = new JField((JType)new JClass("SAXTransformerFactory"), "transformerFactory");
        factoryField.getModifiers().setFinal(true);
        factoryField.setInitString("(SAXTransformerFactory) TransformerFactory.newInstance()");
        jClass.addField(factoryField);
        this.addModelImports(jClass, null);
        String root = objectModel.getRoot(this.getGeneratedVersion());
        ModelClass rootClass = objectModel.getClass(root, this.getGeneratedVersion());
        String rootElement = this.resolveTagName(rootClass);
        JConstructor saxWriterConstructor = new JConstructor(jClass);
        JSourceCode sc = saxWriterConstructor.getSourceCode();
        sc.add("transformerFactory.setAttribute( \"indent-number\", 2 );");
        jClass.addConstructor(saxWriterConstructor);
        JMethod marshall = new JMethod("write");
        String rootElementParameterName = SaxWriterGenerator.uncapitalise((String)root);
        marshall.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("SAXException"));
        marshall.addException(new JClass("TransformerException"));
        sc = marshall.getSourceCode();
        sc.add("TransformerHandler transformerHandler = transformerFactory.newTransformerHandler();");
        sc.add("Properties format = new Properties();");
        sc.add("format.put( OutputKeys.ENCODING, " + rootElementParameterName + ".getModelEncoding() );");
        sc.add("format.put( OutputKeys.INDENT, \"yes\" );");
        sc.add("format.put( OutputKeys.MEDIA_TYPE, \"text/xml\" );");
        sc.add("format.put( OutputKeys.METHOD, \"xml\" );");
        sc.add("transformerHandler.getTransformer().setOutputProperties( format );");
        sc.add("transformerHandler.setResult( new StreamResult( writer ) );");
        sc.add("write( transformerHandler, " + rootElementParameterName + " );");
        jClass.addMethod(marshall);
        marshall = new JMethod("write");
        marshall.addParameter(new JParameter((JType)new JClass("OutputStream"), "stream"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("SAXException"));
        marshall.addException(new JClass("TransformerException"));
        marshall.addException(new JClass("UnsupportedEncodingException"));
        sc = marshall.getSourceCode();
        sc.add("write( new OutputStreamWriter( stream, " + rootElementParameterName + ".getModelEncoding() ), " + rootElementParameterName + " );");
        jClass.addMethod(marshall);
        marshall = new JMethod("write");
        marshall.addParameter(new JParameter((JType)new JClass("ContentHandler"), "contentHandler"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("SAXException"));
        sc = marshall.getSourceCode();
        sc.add("write( contentHandler, " + rootElementParameterName + ", true );");
        jClass.addMethod(marshall);
        marshall = new JMethod("write");
        marshall.addParameter(new JParameter((JType)new JClass("ContentHandler"), "contentHandler"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addParameter(new JParameter(JType.BOOLEAN, "startDocument"));
        marshall.addException(new JClass("SAXException"));
        sc = marshall.getSourceCode();
        sc.add("if ( startDocument )");
        sc.add("{");
        sc.addIndented("contentHandler.startDocument();");
        sc.add("}");
        sc.add("AttributesImpl attributes = new AttributesImpl();");
        sc.add("write" + root + "( " + rootElementParameterName + ", \"" + rootElement + "\", contentHandler, attributes );");
        sc.add("if ( startDocument )");
        sc.add("{");
        sc.addIndented("contentHandler.endDocument();");
        sc.add("}");
        jClass.addMethod(marshall);
        marshall = new JMethod("writeText");
        marshall.getModifiers().makePrivate();
        marshall.addParameter(new JParameter((JType)new JClass("String"), "text"));
        marshall.addParameter(new JParameter((JType)new JClass("ContentHandler"), "contentHandler"));
        marshall.addException(new JClass("SAXException"));
        sc = marshall.getSourceCode();
        sc.add("contentHandler.characters( text.toCharArray(), 0, text.length() );");
        jClass.addMethod(marshall);
        this.writeAllClasses(objectModel, jClass);
        if (this.requiresDomSupport) {
            this.createWriteDomMethod(jClass);
            this.createXpp3DomMethod(jClass);
        }
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClasses(Model objectModel, JClass jClass) throws ModelloException {
        for (ModelClass clazz : this.getClasses(objectModel)) {
            this.writeClass(clazz, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) throws ModelloException {
        String value;
        String type;
        String fieldTagName;
        JavaFieldMetadata javaFieldMetadata;
        XmlFieldMetadata xmlFieldMetadata;
        String className = modelClass.getName();
        String uncapClassName = SaxWriterGenerator.uncapitalise((String)className);
        JMethod marshall = new JMethod("write" + className);
        marshall.addParameter(new JParameter((JType)new JClass(className), uncapClassName));
        marshall.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        marshall.addParameter(new JParameter((JType)new JClass("ContentHandler"), "contentHandler"));
        marshall.addParameter(new JParameter((JType)new JClass("AttributesImpl"), "attributes"));
        marshall.addException(new JClass("SAXException"));
        marshall.getModifiers().makePrivate();
        JSourceCode sc = marshall.getSourceCode();
        ModelClassMetadata classMetadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        String namespace = null;
        XmlModelMetadata xmlModelMetadata = (XmlModelMetadata)modelClass.getModel().getMetadata(XmlModelMetadata.ID);
        ModelField contentField = null;
        String contentValue = null;
        List modelFields = this.getFieldsForXml(modelClass, this.getGeneratedVersion());
        boolean needsToCleanAttributes = false;
        for (ModelField field : modelFields) {
            xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            type = field.getType();
            value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (xmlFieldMetadata.isContent()) {
                contentField = field;
                contentValue = value;
                continue;
            }
            if (!xmlFieldMetadata.isAttribute()) continue;
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.addIndented("attributes.addAttribute( NAMESPACE, \"" + fieldTagName + "\", \"" + fieldTagName + "\", \"CDATA\", " + this.getValue(field.getType(), value, xmlFieldMetadata) + " );");
            sc.add("}");
            needsToCleanAttributes = true;
        }
        if (classMetadata.isRootElement() && xmlModelMetadata.getNamespace() != null) {
            namespace = xmlModelMetadata.getNamespace(this.getGeneratedVersion());
            sc.add("contentHandler.startPrefixMapping( \"\", \"" + namespace + "\" );");
        }
        if (namespace != null && xmlModelMetadata.getSchemaLocation() != null) {
            String url = xmlModelMetadata.getSchemaLocation(this.getGeneratedVersion());
            sc.add("contentHandler.startPrefixMapping( \"xsi\", \"http://www.w3.org/2001/XMLSchema-instance\" );");
            sc.add("attributes.addAttribute( \"http://www.w3.org/2001/XMLSchema-instance\", \"schemaLocation\", \"xsi:schemaLocation\", \"CDATA\", \"" + namespace + " " + url + "\" );");
        }
        sc.add("contentHandler.startElement( NAMESPACE, tagName, tagName, attributes );");
        if (needsToCleanAttributes) {
            sc.add("attributes.clear();");
        }
        if (contentField != null) {
            XmlFieldMetadata xmlFieldMetadata2 = (XmlFieldMetadata)contentField.getMetadata(XmlFieldMetadata.ID);
            sc.add("writeText( " + this.getValue(contentField.getType(), contentValue, xmlFieldMetadata2) + ", contentHandler );");
        }
        for (ModelField field : modelFields) {
            xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (xmlFieldMetadata.isContent()) continue;
            javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            type = field.getType();
            value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (xmlFieldMetadata.isAttribute()) continue;
            if (field instanceof ModelAssociation) {
                ModelAssociation association = (ModelAssociation)field;
                String associationName = association.getName();
                if (association.isOneMultiplicity()) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.addIndented("write" + association.getTo() + "( (" + association.getTo() + ") " + value + ", \"" + fieldTagName + "\", contentHandler, attributes );");
                    sc.add("}");
                    continue;
                }
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                String valuesTagName = this.resolveTagName(fieldTagName, xmlAssociationMetadata);
                type = association.getType();
                String toType = association.getTo();
                boolean wrappedItems = xmlAssociationMetadata.isWrappedItems();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    if (wrappedItems) {
                        sc.add("contentHandler.startElement( NAMESPACE, \"" + fieldTagName + "\", \"" + fieldTagName + "\", attributes );");
                    }
                    sc.add("for ( Iterator iter = " + value + ".iterator(); iter.hasNext(); )");
                    sc.add("{");
                    sc.indent();
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add(toType + " o = (" + toType + ") iter.next();");
                        sc.add("write" + toType + "( o, \"" + valuesTagName + "\", contentHandler, attributes );");
                    } else {
                        sc.add(toType + " " + SaxWriterGenerator.singular((String)SaxWriterGenerator.uncapitalise((String)field.getName())) + " = (" + toType + ") iter.next();");
                        sc.add("contentHandler.startElement( NAMESPACE, \"" + valuesTagName + "\", \"" + valuesTagName + "\", attributes );");
                        sc.add("writeText( " + SaxWriterGenerator.singular((String)SaxWriterGenerator.uncapitalise((String)field.getName())) + ", contentHandler );");
                        sc.add("contentHandler.endElement( NAMESPACE, \"" + valuesTagName + "\", \"" + valuesTagName + "\" );");
                    }
                    sc.unindent();
                    sc.add("}");
                    if (wrappedItems) {
                        sc.add("contentHandler.endElement( NAMESPACE, \"" + fieldTagName + "\", \"" + fieldTagName + "\" );");
                    }
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                sc.add(this.getValueChecker(type, value, field));
                sc.add("{");
                sc.indent();
                if (wrappedItems) {
                    sc.add("contentHandler.startElement( NAMESPACE, \"" + fieldTagName + "\", \"" + fieldTagName + "\", attributes );");
                }
                sc.add("for ( Iterator iter = " + value + ".keySet().iterator(); iter.hasNext(); )");
                sc.add("{");
                sc.indent();
                sc.add("String key = (String) iter.next();");
                sc.add(association.getTo() + " value = (" + association.getTo() + ") " + value + ".get( key );");
                if (xmlAssociationMetadata.isMapExplode()) {
                    sc.add("contentHandler.startElement( NAMESPACE, \"" + SaxWriterGenerator.singular((String)associationName) + "\", \"" + SaxWriterGenerator.singular((String)associationName) + "\", attributes );");
                    sc.add("contentHandler.startElement( NAMESPACE, \"key\", \"key\", attributes );");
                    sc.add("writeText( key, contentHandler );");
                    sc.add("contentHandler.endElement( NAMESPACE, \"key\", \"key\" );");
                    if (this.isClassInModel(association.getTo(), association.getModelClass().getModel())) {
                        sc.add("write" + association.getTo() + "( value, \"value\", contentHandler, attributes );");
                    } else {
                        sc.add("contentHandler.startElement( NAMESPACE, \"value\", \"value\", attributes );");
                        sc.add("writeText( " + this.getValue(association.getTo(), "value", xmlFieldMetadata) + ", contentHandler );");
                        sc.add("contentHandler.endElement( NAMESPACE, \"value\", \"value\" );");
                    }
                    sc.add("contentHandler.endElement( NAMESPACE, \"" + SaxWriterGenerator.singular((String)associationName) + "\", \"" + SaxWriterGenerator.singular((String)associationName) + "\" );");
                } else if (this.isClassInModel(association.getTo(), association.getModelClass().getModel())) {
                    sc.add("write" + association.getTo() + "( value, key, contentHandler, attributes );");
                } else {
                    sc.add("contentHandler.startElement( NAMESPACE, key, key, attributes );");
                    sc.add("writeText( " + this.getValue(association.getTo(), "value", xmlFieldMetadata) + ", contentHandler );");
                    sc.add("contentHandler.endElement( NAMESPACE, key, key );");
                }
                sc.unindent();
                sc.add("}");
                if (wrappedItems) {
                    sc.add("contentHandler.endElement( NAMESPACE, \"" + fieldTagName + "\", \"" + fieldTagName + "\" );");
                }
                sc.unindent();
                sc.add("}");
                continue;
            }
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            if ("DOM".equals(field.getType())) {
                if (this.domAsXpp3) {
                    sc.addIndented("writeDom( (Xpp3Dom) " + value + ", contentHandler, attributes );");
                } else {
                    sc.addIndented("writeDom( (Element) " + value + ", contentHandler );");
                }
                this.requiresDomSupport = true;
            } else {
                sc.indent();
                sc.add("contentHandler.startElement( NAMESPACE, \"" + fieldTagName + "\", \"" + fieldTagName + "\", attributes );");
                sc.add("writeText( " + this.getValue(field.getType(), value, xmlFieldMetadata) + ", contentHandler );");
                sc.add("contentHandler.endElement( NAMESPACE, \"" + fieldTagName + "\", \"" + fieldTagName + "\" );");
                sc.unindent();
            }
            sc.add("}");
        }
        sc.add("contentHandler.endElement( NAMESPACE, tagName, tagName );");
        jClass.addMethod(marshall);
    }

    private void createXpp3DomMethod(JClass jClass) {
        jClass.addImport("org.codehaus.plexus.util.xml.Xpp3Dom");
        JMethod method = new JMethod("writeDom");
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter(new JType("Xpp3Dom"), "dom"));
        method.addParameter(new JParameter((JType)new JClass("ContentHandler"), "contentHandler"));
        method.addParameter(new JParameter((JType)new JClass("AttributesImpl"), "attributes"));
        method.addException(new JClass("SAXException"));
        JSourceCode sc = method.getSourceCode();
        sc.add("String[] attributeNames = dom.getAttributeNames();");
        sc.add("if ( attributeNames != null && attributeNames.length > 0 )");
        sc.add("{");
        sc.indent();
        sc.add("String attributeName;");
        sc.add("String attributeValue;");
        sc.add("for ( int i = 0; i < attributeNames.length; i++ )");
        sc.add("{");
        sc.indent();
        sc.add("attributeName = attributeNames[i];");
        sc.add("attributeValue = dom.getAttribute( attributeName );");
        sc.add("attributes.addAttribute( NAMESPACE, attributeName, attributeName, \"CDATA\", attributeValue );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("contentHandler.startElement( NAMESPACE, dom.getName(), dom.getName(), attributes );");
        sc.add("if ( attributeNames != null && attributeNames.length > 0 )");
        sc.add("{");
        sc.addIndented("attributes.clear();");
        sc.add("}");
        sc.add("Xpp3Dom[] children = dom.getChildren();");
        sc.add("if ( children != null &&  children.length > 0 )");
        sc.add("{");
        sc.indent();
        sc.add("for ( int i = 0; i < children.length; i++ )");
        sc.add("{");
        sc.addIndented("writeDom( children[i], contentHandler, attributes );");
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("String value = dom.getValue();");
        sc.add("if ( value != null )");
        sc.add("{");
        sc.addIndented("writeText( value, contentHandler );");
        sc.add("}");
        sc.add("contentHandler.endElement( NAMESPACE, dom.getName(), dom.getName() );");
        jClass.addMethod(method);
    }

    private void createWriteDomMethod(JClass jClass) {
        jClass.addImport("org.w3c.dom.Element");
        jClass.addImport("javax.xml.transform.Transformer");
        jClass.addImport("javax.xml.transform.dom.DOMSource");
        jClass.addImport("javax.xml.transform.sax.SAXResult");
        JMethod method = new JMethod("writeDom");
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter(new JType("Element"), "dom"));
        method.addParameter(new JParameter((JType)new JClass("ContentHandler"), "contentHandler"));
        method.addException(new JClass("SAXException"));
        JSourceCode sc = method.getSourceCode();
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add("Transformer transformer = transformerFactory.newTransformer();");
        sc.add("DOMSource source = new DOMSource( dom );");
        sc.add("SAXResult result = new SAXResult( contentHandler );");
        sc.add("transformer.transform( source, result );");
        sc.unindent();
        sc.add("}");
        sc.add("catch ( TransformerException e )");
        sc.add("{");
        sc.addIndented("throw new SAXException( \"Impossible to convert DOM element, see nested exceptions.\", e );");
        sc.add("}");
        jClass.addMethod(method);
    }
}

