/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux;

import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.cometd.bayeux.Transport;

public interface Bayeux {
    public Set<String> getKnownTransportNames();

    public Transport getTransport(String var1);

    public List<String> getAllowedTransports();

    public Object getOption(String var1);

    public void setOption(String var1, Object var2);

    public Set<String> getOptionNames();

    public static class Validator {
        public static boolean isValidChannelId(String channelId) {
            if (channelId.length() < 2) {
                return false;
            }
            if (channelId.charAt(0) != '/') {
                return false;
            }
            for (int i = 1; i < channelId.length(); ++i) {
                char c = channelId.charAt(i);
                if (Validator.isAlpha(c) || Validator.isNumeric(c) || Validator.isAllowed(c)) continue;
                return false;
            }
            return true;
        }

        public static boolean isValidMessageId(String messageId) {
            if (messageId.isEmpty()) {
                return false;
            }
            for (int i = 0; i < messageId.length(); ++i) {
                char c = messageId.charAt(i);
                if (Validator.isAlpha(c) || Validator.isNumeric(c)) continue;
                return false;
            }
            return true;
        }

        private static boolean isAlpha(char c) {
            if (c >= 'A' && c <= 'Z') {
                return true;
            }
            return c >= 'a' && c <= 'z';
        }

        private static boolean isNumeric(char c) {
            return c >= '0' && c <= '9';
        }

        private static boolean isAllowed(char c) {
            return switch (c) {
                case ' ', '!', '#', '$', '(', ')', '*', '+', '-', '.', '/', '@', '_', '{', '}', '~' -> true;
                default -> false;
            };
        }

        private Validator() {
        }
    }

    public static interface BayeuxListener
    extends EventListener {
    }
}

