/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.ref;

import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleTypeAndClassifier;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;

public class SimpleVersionlessArtifactRef
extends SimpleProjectRef
implements VersionlessArtifactRef {
    private static final long serialVersionUID = 1L;
    private final TypeAndClassifier tc;

    public SimpleVersionlessArtifactRef(ArtifactRef ref) {
        super(ref.getGroupId(), ref.getArtifactId());
        this.tc = ref.getTypeAndClassifier();
    }

    public SimpleVersionlessArtifactRef(ProjectRef ref, String type, String classifier) {
        super(ref.getGroupId(), ref.getArtifactId());
        this.tc = new SimpleTypeAndClassifier(type, classifier);
    }

    public SimpleVersionlessArtifactRef(ProjectRef ref, TypeAndClassifier tc) {
        super(ref.getGroupId(), ref.getArtifactId());
        this.tc = tc == null ? new SimpleTypeAndClassifier() : tc;
    }

    public SimpleVersionlessArtifactRef(String groupId, String artifactId, String type, String classifier) throws InvalidVersionSpecificationException {
        super(groupId, artifactId);
        this.tc = new SimpleTypeAndClassifier(type, classifier);
    }

    public <T extends VersionlessArtifactRef> SimpleVersionlessArtifactRef(VersionlessArtifactRef ref) {
        super(ref);
        this.tc = ref.getTypeAndClassifier();
    }

    @Override
    public String toString() {
        return String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getTypeAndClassifier());
    }

    public static VersionlessArtifactRef parse(String spec) {
        String[] parts = spec.split(":");
        if (parts.length < 2 || StringUtils.isEmpty((String)parts[0]) || StringUtils.isEmpty((String)parts[1])) {
            throw new InvalidRefException("VersionlessArtifactRef must contain AT LEAST non-empty groupId and artifactId. (Given: '" + spec + "')", new Object[0]);
        }
        String g = parts[0];
        String a = parts[1];
        String t = "pom";
        String c = null;
        if (parts.length > 2) {
            t = parts[2];
            if (parts.length > 3) {
                c = parts[3];
                if (parts.length > 4) {
                    c = parts[4];
                }
            }
        }
        return new SimpleVersionlessArtifactRef(g, a, t, c);
    }

    @Override
    public String getType() {
        return this.tc.getType();
    }

    @Override
    public String getClassifier() {
        return this.tc.getClassifier();
    }

    @Override
    public TypeAndClassifier getTypeAndClassifier() {
        return this.tc;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.tc == null ? 0 : this.tc.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof VersionlessArtifactRef)) {
            return false;
        }
        VersionlessArtifactRef other = (VersionlessArtifactRef)obj;
        return !(this.tc == null ? other.getTypeAndClassifier() != null : !this.tc.equals(other.getTypeAndClassifier()));
    }

    @Override
    public VersionlessArtifactRef asVersionlessPomArtifact() {
        return this.asVersionlessArtifactRef("pom", null);
    }

    @Override
    public VersionlessArtifactRef asVersionlessJarArtifact() {
        return this.asVersionlessArtifactRef("jar", null);
    }

    @Override
    public VersionlessArtifactRef asVersionlessArtifactRef(String type, String classifier) {
        SimpleTypeAndClassifier tc = new SimpleTypeAndClassifier(type, classifier);
        if (SimpleVersionlessArtifactRef.class.equals(this.getClass()) && this.tc.equals(tc)) {
            return this;
        }
        return super.asVersionlessArtifactRef(type, classifier);
    }

    @Override
    public VersionlessArtifactRef asVersionlessArtifactRef(TypeAndClassifier tc) {
        if (SimpleVersionlessArtifactRef.class.equals(this.getClass()) && this.tc.equals(tc)) {
            return this;
        }
        return super.asVersionlessArtifactRef(tc);
    }
}

