/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.commonjava.maven.atlas.graph.rel.DependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.PluginDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.PluginRelationship;
import org.commonjava.maven.atlas.graph.rel.ProjectRelationship;

public final class ProjectRelationshipSerializer<T extends ProjectRelationship>
extends StdSerializer<T> {
    public ProjectRelationshipSerializer(Class<T> cls) {
        super(cls);
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
        gen.writeStartObject();
        gen.writeStringField("type", value.getType().name());
        gen.writeStringField("pom-location-uri", value.getPomLocation().toString());
        gen.writeBooleanField("inherited", value.isInherited());
        Set<URI> sources = value.getSources();
        if (sources != null) {
            Iterator<URI> iter = sources.iterator();
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                iter.remove();
            }
            if (!sources.isEmpty()) {
                gen.writeArrayFieldStart("source-uris");
                for (URI uri : sources) {
                    if (uri == null) continue;
                    gen.writeString(uri.toString());
                }
                gen.writeEndArray();
            }
        }
        provider.defaultSerializeField("declaring", (Object)value.getDeclaring(), gen);
        provider.defaultSerializeField("target", value.getTarget(), gen);
        switch (value.getType()) {
            case BOM: {
                gen.writeBooleanField("mixin", value.isMixin());
                break;
            }
            case DEPENDENCY: {
                gen.writeStringField("scope", ((DependencyRelationship)value).getScope().realName());
                gen.writeBooleanField("managed", value.isManaged());
                gen.writeBooleanField("optional", ((DependencyRelationship)value).isOptional());
                break;
            }
            case PLUGIN_DEP: {
                provider.defaultSerializeField("plugin", (Object)((PluginDependencyRelationship)value).getPlugin(), gen);
                gen.writeBooleanField("managed", value.isManaged());
                break;
            }
            case PLUGIN: {
                gen.writeBooleanField("managed", value.isManaged());
                gen.writeBooleanField("reporting", ((PluginRelationship)value).isReporting());
            }
        }
        gen.writeNumberField("idx", value.getIndex());
        gen.writeEndObject();
    }
}

