/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Resource;
import org.commonjava.maven.galley.model.VirtualResource;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Alternative
public class NoOpLocationExpander
implements LocationExpander {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public <T extends Location> List<Location> expand(Collection<T> locations) throws TransferException {
        this.logger.debug("NOOP: No expansion available for: {}", locations);
        return locations instanceof List ? (List<Object>)locations : new ArrayList<T>(locations);
    }

    @Override
    public List<Location> expand(Location ... locations) throws TransferException {
        this.logger.debug("NOOP: No expansion available for: {}", (Object)Arrays.toString(locations));
        return Arrays.asList(locations);
    }

    @Override
    public VirtualResource expand(Resource resource) {
        this.logger.debug("NOOP: No expansion available for: {}", (Object)resource);
        if (resource instanceof VirtualResource) {
            return (VirtualResource)resource;
        }
        return new VirtualResource((ConcreteResource)resource);
    }
}

