/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.plugins.projectsrc;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;

@Mojo(name="archive", requiresDependencyResolution=ResolutionScope.NONE, requiresDependencyCollection=ResolutionScope.NONE, requiresOnline=false, requiresProject=true, defaultPhase=LifecyclePhase.INITIALIZE)
public class ProjectSourcesGoal
extends AbstractMojo
implements AssemblerConfigurationSource {
    private static final String PROJECT_DESCRIPTOR = "project";
    private static final List<String> FORMATS = Collections.unmodifiableList(Collections.singletonList("tar.gz"));
    private static final String CLASSIFIER = "project-sources";
    @Component
    protected AssemblyArchiver archiver;
    @Component
    protected AssemblyReader reader;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected MavenFileFilter mavenFileFilter;
    @Component
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    protected File basedir;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/projectsrc-archive-tmp", required=true, readonly=true)
    protected File tempRoot;
    @Parameter(defaultValue="${project.build.directory}/projectsrc-work", required=true)
    protected File workDirectory;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    protected String finalName;
    @Parameter(property="project.src.skip")
    protected boolean skipProjectSources;

    protected ProjectSourcesGoal() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipProjectSources) {
            this.getLog().info((CharSequence)"Assemblies have been skipped per configuration of the skipAssembly parameter.");
            return;
        }
        if (!this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the assembly in this project because it's not the Execution Root");
            return;
        }
        Assembly assembly = this.getAssembly();
        try {
            String fullName = AssemblyFormatUtils.getDistributionName((Assembly)assembly, (AssemblerConfigurationSource)this);
            for (String format : assembly.getFormats()) {
                File destFile = this.archiver.createArchive(assembly, fullName, format, (AssemblerConfigurationSource)this, true);
                MavenProject project = this.getProject();
                this.projectHelper.attachArtifact(project, format, assembly.getId(), destFile);
            }
        }
        catch (ArchiveCreationException e) {
            throw new MojoExecutionException("Failed to create assembly: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (AssemblyFormattingException e) {
            throw new MojoExecutionException("Failed to create assembly: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoFailureException((Object)assembly, "Assembly is incorrectly configured: " + assembly.getId(), "Assembly: " + assembly.getId() + " is not configured correctly: " + e.getMessage());
        }
    }

    private Assembly getAssembly() throws MojoExecutionException, MojoFailureException {
        List assemblies;
        try {
            assemblies = this.reader.readAssemblies((AssemblerConfigurationSource)this);
        }
        catch (AssemblyReadException e) {
            throw new MojoExecutionException("Error reading assemblies: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoFailureException((Object)this.reader, e.getMessage(), "Mojo configuration is invalid: " + e.getMessage());
        }
        if (assemblies == null || assemblies.isEmpty()) {
            throw new MojoExecutionException("Cannot read 'project' assembly descriptor!");
        }
        Assembly assembly = (Assembly)assemblies.get(0);
        assembly.setId(CLASSIFIER);
        assembly.setFormats(FORMATS);
        return assembly;
    }

    private boolean isThisTheExecutionRoot() {
        Log log = this.getLog();
        log.debug((CharSequence)("Root Folder:" + this.mavenSession.getExecutionRootDirectory()));
        log.debug((CharSequence)("Current Folder:" + this.basedir));
        boolean result = this.mavenSession.getExecutionRootDirectory().equalsIgnoreCase(this.basedir.toString());
        if (result) {
            log.debug((CharSequence)"This is the execution root.");
        } else {
            log.debug((CharSequence)"This is NOT the execution root.");
        }
        return result;
    }

    public File getArchiveBaseDirectory() {
        return null;
    }

    public String getArchiverConfig() {
        return null;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String getClassifier() {
        return null;
    }

    public String getDescriptor() {
        return null;
    }

    public String getDescriptorId() {
        return null;
    }

    public String[] getDescriptorReferences() {
        return new String[]{PROJECT_DESCRIPTOR};
    }

    public File getDescriptorSourceDirectory() {
        return null;
    }

    public String[] getDescriptors() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public String getEscapeString() {
        return null;
    }

    public List<String> getFilters() {
        return null;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public MavenArchiveConfiguration getJarArchiveConfiguration() {
        return null;
    }

    public ArtifactRepository getLocalRepository() {
        return this.mavenSession.getLocalRepository();
    }

    public MavenFileFilter getMavenFileFilter() {
        return this.mavenFileFilter;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.project.getRemoteArtifactRepositories();
    }

    public File getSiteDirectory() {
        return null;
    }

    public String getTarLongFileMode() {
        return "gnu";
    }

    public File getTemporaryRootDirectory() {
        return this.tempRoot;
    }

    public File getWorkingDirectory() {
        return this.workDirectory;
    }

    public boolean isAssemblyIdAppended() {
        return true;
    }

    public boolean isDryRun() {
        return false;
    }

    public boolean isIgnoreDirFormatExtensions() {
        return false;
    }

    public boolean isIgnoreMissingDescriptor() {
        return false;
    }

    public boolean isIgnorePermissions() {
        return false;
    }

    public boolean isSiteIncluded() {
        return false;
    }

    public boolean isUpdateOnly() {
        return false;
    }

    public boolean isUseJvmChmod() {
        return true;
    }
}

