/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.datadog.transport;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.coursera.metrics.datadog.model.DatadogCounter;
import org.coursera.metrics.datadog.model.DatadogGauge;
import org.coursera.metrics.datadog.transport.Transport;
import org.coursera.metrics.serializer.JsonSerializer;
import org.coursera.metrics.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTransport.class);
    private static final String BASE_URL = "https://app.datadoghq.com/api/v1";
    private final String seriesUrl;
    private final int connectTimeout;
    private final int socketTimeout;
    private final HttpHost proxy;

    private HttpTransport(String apiKey, int connectTimeout, int socketTimeout, HttpHost proxy) {
        this.seriesUrl = String.format("%s/series?api_key=%s", BASE_URL, apiKey);
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.proxy = proxy;
    }

    public Transport.Request prepare() throws IOException {
        return new HttpRequest(this);
    }

    public void close() throws IOException {
    }

    public static class HttpRequest
    implements Transport.Request {
        protected final Serializer serializer;
        protected final HttpTransport transport;

        public HttpRequest(HttpTransport transport) throws IOException {
            this.transport = transport;
            this.serializer = new JsonSerializer();
            this.serializer.startObject();
        }

        public void addGauge(DatadogGauge gauge) throws IOException {
            this.serializer.appendGauge(gauge);
        }

        public void addCounter(DatadogCounter counter) throws IOException {
            this.serializer.appendCounter(counter);
        }

        public void send() throws Exception {
            this.serializer.endObject();
            String postBody = this.serializer.getAsString();
            if (LOG.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Sending HTTP POST request to ");
                sb.append(this.transport.seriesUrl);
                sb.append(", POST body is: \n");
                sb.append(postBody);
                LOG.debug(sb.toString());
            }
            long start = System.currentTimeMillis();
            Request request = Request.Post((String)this.transport.seriesUrl).useExpectContinue().connectTimeout(this.transport.connectTimeout).socketTimeout(this.transport.socketTimeout).bodyString(postBody, ContentType.APPLICATION_JSON);
            if (this.transport.proxy != null) {
                request.viaProxy(this.transport.proxy);
            }
            Response response = request.execute();
            long elapsed = System.currentTimeMillis() - start;
            if (LOG.isDebugEnabled()) {
                HttpResponse httpResponse = response.returnResponse();
                StringBuilder sb = new StringBuilder();
                sb.append("Sent metrics to Datadog: ");
                sb.append("  Timing: ").append(elapsed).append(" ms\n");
                sb.append("  Status: ").append(httpResponse.getStatusLine().getStatusCode()).append("\n");
                String content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                sb.append("  Content: ").append(content);
                LOG.debug(sb.toString());
            } else {
                response.discardContent();
            }
        }
    }

    public static class Builder {
        String apiKey;
        int connectTimeout = 5000;
        int socketTimeout = 5000;
        HttpHost proxy;

        public Builder withApiKey(String key) {
            this.apiKey = key;
            return this;
        }

        public Builder withConnectTimeout(int milliseconds) {
            this.connectTimeout = milliseconds;
            return this;
        }

        public Builder withSocketTimeout(int milliseconds) {
            this.socketTimeout = milliseconds;
            return this;
        }

        public Builder withProxy(String proxyHost, int proxyPort) {
            this.proxy = new HttpHost(proxyHost, proxyPort);
            return this;
        }

        public HttpTransport build() {
            return new HttpTransport(this.apiKey, this.connectTimeout, this.socketTimeout, this.proxy);
        }
    }
}

