/*
 * Copyright (C) 2007-2020 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

CStudioAuthoring.Messages.registerBundle('siteDashboard', 'de', {
  dashboardTitle: 'Dashboard',

  dashboardCollapseAll: 'Alle zuklappen',
  dashboardExpandAll: 'Alle aufklappen',
  dashboardEdit: 'Bearbeiten',

  approvedScheduledCollapseAll: 'Alle zuklappen',

  dashletFilterPages: 'Seiten',
  dashletFilterComponents: 'Komponenten',
  dashletFilterDocuments: 'Dokumente',
  dashletFilterAssets: 'Assets',
  dashletFilterAll: 'Alle',

  dashletGoLiveQueueTitle: 'Bereit zur Freigabe',
  dashletGoLiveCollapseAll: 'Alle zuklappen',
  dashletGoLiveExpandAll: 'Alle aufklappen',
  dashletGoLiveShowInProgress: '"In Bearbeitung"-Inhalte anzeigen',
  dashletGoLiveHideInProgress: '"In Bearbeitung"-Inhalte verbergen',
  dashletGoLiveColPageName: 'Name',
  dashletGoLiveColView: 'Ansehen',
  dashletGoLiveColEdit: 'Bearbeiten',
  dashletGoLiveColURL: 'URL',
  dashletGoLiveColEnvironment: 'Umgebung',
  dashletGoLiveColPublishDate: 'Veröffentlichungsdatum',
  dashletGoLiveColLastEditedBy: 'Zuletzt bearbeitet von',
  dashletGoLiveColLastEditedDate: 'Zuletzt bearbeitet',
  dashletGoLivePages: 'Seiten ({0})',
  dashletGoLiveComponents: 'Komponenten ({0})',
  dashletGoLiveAssets: 'Assets ({0})',
  dashletGoLiveEdit: 'Bearbeiten',

  dashletApprovedSchedTitle: 'Zur Veröffentlichung freigegeben',
  dashletApprovedSchedCollapseAll: 'Alle zuklappen',
  dashletApprovedSchedExpandAll: 'Alle aufklappen',
  dashletApprovedSchedShow: 'Zeigen',
  dashletApprovedSchedColGoLiveDate: 'Veröffentlichungsdatum',
  dashletApprovedSchedColEdit: 'Bearbeiten',
  dashletApprovedSchedColURL: 'URL',
  dashletApprovedSchedColEnvironment: 'Umgebung',
  dashletApprovedSchedColPackageId: 'Package ID',
  dashletApprovedSchedColLastEdited: 'Zuletzt bearbeitet',
  dashletApprovedSchedFilterPages: 'Seiten',
  dashletApprovedSchedFilterComponents: 'Komponenten',
  dashletApprovedSchedFilterDocuments: 'Dokumente',
  dashletApprovedSchedFilterAll: 'Alle',

  showNumItems: 'Zeigen',

  dashletRecentDeployTitle: 'Zuletzt veröffentlicht',
  dashletRecentDeployCollapseAll: 'Alle zuklappen',
  dashletRecentDeployExpandAll: 'Alle aufklappen',
  dashletRecentDeployShow: 'Zeigen',
  dashletRecentDeployColMadeLiveDateDate: 'Veröffentlichungsdatum',
  dashletRecentDeployColEdit: 'Bearbeiten',
  dashletRecentDeployColURL: 'URL',
  dashletRecentDeployColEndpoint: 'Umgebung',
  dashletRecentDeployColDeployBy: 'Publiziert durch',
  dashletRecentDeployColLastEdited: 'Zuletzt bearbeitet',
  dashletRecentDeployColPageName: 'Name',

  dashletMyRecentActivityTitle: 'Meine letzten Aktivitäten',
  dashletMyRecentActivityCollapseAll: 'Alle zuklappen',
  dashletMyRecentActivityExpandAll: 'Alle aufklappen',
  dashletMyRecentActivityHideLiveItems: 'Live-Inhalte verbergen',
  dashletMyRecentActivityShowLiveItems: 'Live-Inhalte zeigen',
  ddashletMyRecentActivityShow: 'Zeigen',
  dashletMyRecentActivityColPageName: 'Name',
  dashletMyRecentActivityColEdit: 'Bearbeiten',
  dashletMyRecentActivityColURL: 'URL',
  dashletMyRecentActivityColPublishDate: 'Veröffentlichungsdatum',
  dashletMyRecentActivityColLastEditedBy: 'Zuletzt bearbeitet von',
  dashletMyRecentActivityColMyLastEdit: 'Meine letzte Änderung',

  dashletIconGuideTitle: 'Symbolübersicht',
  dashletWorkflowStatesTitle: 'Status',
  dashletItemTypesTitle: 'Inhaltstypen',
  dashletIconGuideNavigationPage: 'Navigationsseite',
  dashletIconGuideFloatingPage: 'Positionierbare Seite',
  dashletIconGuideComponent: 'Komponente',
  dashletIconGuideDocument: 'Dokument',
  dashletIconGuideStateNew: 'Nie veröffentlicht',
  dashletIconGuideStateDisabled: 'Deaktiviert',
  dashletIconGuideStateDeleted: 'Gelöscht',
  dashletIconGuideStateInProgress: 'Bearbeitet',
  dashletIconGuideStateInWorkflow: 'Im Workflow',
  dashletIconGuideStateScheduled: 'Geplant',
  dashletIconGuideStateSystemProcessing: 'In Bearbeitung',
  dashletIconGuideStateLocked: 'Zum Bearbeiten gesperrt',
  dashletIconGuideTemplateScript: 'Template oder Script',
  dashletIconGuideTaxonomy: 'Taxonomie',
  dashletIconGuideImage: 'Bild',
  dashletIconGuideVideo: 'Video',
  dashletIconGuideCss: 'CSS',
  dashletIconGuideFont: 'Font',
  dashletIconGuidePdf: 'PDF',
  dashletIconGuidePowerPoint: 'MS PowerPoint',
  dashletIconGuideWord: 'MS Word',
  dashletIconGuideExcel: 'MS Excel',
  dashletIconGuideZip: 'ZIP',
  dashletIconGuideGroovy: 'Groovy',
  dashletIconGuideOtherFiles: 'sonstige Datei'
});

CStudioAuthoring.Messages.registerBundle('contextnav', 'de', {
  siteContent: 'Projekt-Inhalt',
  sideBar: 'Seitenleiste',

  wcmContentEdit: 'Bearbeiten',
  wcmContentView: 'Ansehen',
  wcmContentSubmit: 'Veröffentlichung anfordern',
  wcmContentDependencies: 'Abhängigkeiten',
  wcmContentDelete: 'Löschen',
  wcmContentSubmitDelete: 'Löschen anfordern',
  wcmContentReject: 'Ablehnen',
  wcmContentSchedule: 'Planen',
  wcmContentApprove: 'Freigeben und veröffentlichen',
  wcmContentDuplicate: 'Duplizieren',
  wcmContentHistory: 'Verlauf',
  wcmContentPageDisabled: 'Dieser Inhalt ist deaktiviert',
  wcmContentSavedAsDraft:
    'Dieser Inhalt wurde als ENTWURF gespeichert. Pflichtfelder sind möglicherweise nicht ausgefüllt. Das kann zu Fehlern in der Vorschau und/oder Veröffentlichung führen.',

  InProgress: 'Bearbeitet',
  Deleted: 'Gelöscht',
  SubmittedforDelete: 'Zum Löschen eingereicht',
  mixedStates: 'Inhalte (verschiedene Zustände)',
  Submitted: 'Zum Veröffentlichen eingereicht',
  Live: 'Live',
  Scheduled: 'Geplant',

  search: 'Suche',

  logout: 'Abmelden',
  close: 'Schließen',

  variableLabel: 'Beispiele für Templates',

  networkError: 'Netzwerk-Fehler. Eventuell eingeschränkte Funktionalität.',

  notification: 'Hinweis',
  noEventError: 'Fehlende Ereignisbehandlung.',

  publishStatus: 'Veröffentlichungsstatus',
  idle: 'Leerlauf',
  busy: 'Beschäftigt',
  ready: 'Bereit',
  stopped: 'Angehalten',
  started: 'Gestartet',
  quickCreateEmpty:
    'Für das schnelle Erstellen sind keine Content-Typen konfiguriert. Bitten wenden Sie sich an Ihren Systemadministrator.'
});

CStudioAuthoring.Messages.registerBundle('previewTools', 'de', {
  previewToolsTitle: 'Werkzeuge',
  inContextEditing: 'Im-Kontext Bearbeitung',
  pageComponents: 'Komponenten',
  responsivePreview: 'Responsive Vorschau',
  desktop: 'Arbeitsplatzrechner',
  browser: 'Browser',
  iphone: 'iPhone5iPhone5S',
  iPad: 'iPad',
  targeting: 'Targeting',
  translation: 'Übersetzung',
  inContextEditOn: 'Im Kontext bearbeiten - An',
  inContextEditOff: 'Im Kontext bearbeiten - Aus',
  publishingChannel: 'Sichtbarer Bereich',
  web: 'Web',
  smartPhone: 'Smartphone',
  tablet: 'Tablet',
  multiVariantTesting: 'Mehr-Varianten-Test',
  YellowVsBlue: 'Gelbe oder blaue Maske auf der Startseite',
  yellow: 'Gelb',
  blue: 'Blau',
  FacetedVsKeyword: 'Suche: Facette oder Schlüsselwort',
  faceted: 'Facette',
  facetedKeyword: 'Facette & Schlüsselwort',
  keywordOnly: 'Nur Schlüsselwort',
  HomeRedVsBlue: 'Startseite rote/blaue Handlungsaufforderung',
  red: 'Rot',
  catalogPageSorting: 'Katalogseiten sortieren',
  arrivalDate: 'Eingangsdatum',
  priceHightoLow: 'Preis absteigend',
  priceLowtoHigh: 'Preis aufsteigend',
  editTemplate: ' Template',
  editController: ' Controller',
  jumpToRegion: 'Zum Bereich springen',
  dimensionsPx: 'Abmessungen (px)',
  viewPortSize: 'Breite * Höhe in Pixeln',
  presets: 'Voreinstellungen',
  custom: 'Benutzerdefiniert',
  addComponent: 'Komponente hinzufügen',
  done: 'Schließen',
  general: 'Allgemein',
  components: 'Komponenten',
  persona: 'Persona',
  properties: 'Eigenschaften',
  assume: 'Annehmen',
  update: 'Aktualisieren',
  active: 'Aktiv',
  reportsOff: 'Berichte aus',
  reportsError: 'Bericht wegen Fehlers nicht verfügbar',
  addComponent: 'Komponente hinzufügen',
  done: 'Schließen',
  components: 'Komponenten',
  general: 'Allgemein',
  text: 'Text',

  //login
  login: 'Anmeldung',
  emailUsername: 'Email/Nutzername',
  password: 'Passwort',
  signIn: 'Anmelden',
  signBackIn: 'Erneut anmelden',
  signInContinueWorking: 'Erneut anmelden',
  sessionExpireInactivity: 'Die Sitzung ist wegen Inaktivität abgelaufen',
  doneSignOut: 'Abmelden',

  search: 'Suche',
  publishingStatus: 'Status',
  users: 'Benutzer',
  sites: 'Projekte',
  help: 'Hilfe',
  documentation: 'Dokumentation',
  about: 'Über Crafter CMS',
  settings: 'Einstellungen',
  signOut: 'Abmelden',
  mainMenu: 'Hauptmenü',

  videoProcessed:
    'Das Video wird noch verarbeitet. Die Vorschau ist verfügbar sobald die Verarbeitung abgeschlossen ist.',
  quickCreate: 'Schnell erstellen',
  inContextEdit: 'Im-Kontext Bearbeitung'
});

CStudioAuthoring.Messages.registerBundle('siteDropdown', 'de', {
  pages: 'Seiten',
  Pages: 'Seiten',
  page: 'Seiten',
  components: 'Komponenten',
  Components: 'Komponenten',
  component: 'Komponenten',
  classes: 'Classes',
  staticassets: 'Statische Assets',
  templates: 'Templates',
  scripts: 'Scripts',
  adminConsole: 'Adminbereich',
  siteconfig: 'Konfiguration',
  previewSync: 'Vorschau Sync',
  syncrepo: 'Sync aus Repository',
  allSites: 'Alle Projekte',
  dashboard: 'Dashboard',
  newContent: 'Neues Asset',
  newFolder: 'Neues Verzeichnis',
  upload: 'Upload',
  edit: 'Bearbeiten',
  view: 'Ansehen',
  changeTemplate: 'Template wechseln',
  delete: 'Löschen',
  cut: 'Ausschneiden',
  copy: 'Kopieren',
  paste: 'Einfügen',
  duplicate: 'Duplizieren',
  history: 'Historie',
  unlock: 'Entsperren',
  noActionsAvailable: 'Keine Aktion möglich',
  createFolder: 'Neues Verzeichnis',
  renameFolder: 'Verzeichnis umbenennen',
  createTemplate: 'Neues Template',
  templateFilename: 'Vergeben Sie einen Namen für das Template',
  folderName: 'Name des neuen Verzeichnisses',
  createController: 'Neuer Controller',
  controllerFilename: 'Vergeben Sie einen Namen für das Script',
  bulkUploadAssets: 'Massen-Upload',
  lastEdited: 'Zuletzt bearbeitet',
  editedBy: 'Bearbeitet von',
  lockedBy: 'Gesperrt von',
  status: 'Status',
  scheduled: 'Geplant',
  loading: 'Laden...',

  /*tooltip-Status*/
  statusDeleted: 'Gelöscht',
  statusScheduledForDelete: 'Zum Löschen vorgesehen',
  statusSubmittedForDelete: 'Zum Löschen eingereicht',
  statusAndDisabled: 'und deaktiviert',
  statusProcessing: 'in Bearbeitung',
  statusInProgress: 'Bearbeitet',
  statusLive: 'Live',
  statusAnd: 'und',
  statusSubmitted: 'Im Workflow',
  statusScheduled: 'Geplant',
  statusDisabled: 'Deaktiviert',
  wcmContentSubmit: 'Publizieren angefordert',
  wcmContentApprove: 'Freigeben & Publizieren',

  notification: 'Benachrichtigung',
  previewInitiated: 'Vollständige Synchronisation des Vorschau-Servers initialisiert.',
  syncfromRepoInitiated: 'Synchronisation aus Repository initialisiert.',

  lookUpItemError: 'Fehler - bitte kontaktieren Sie Ihren Systemadministrator.',
  pathSameError: 'Quell- und Zielverzeichnis sind identisch.',
  pageExistError: 'Die Seite existiert bereits im Zielverzeichnis.',
  wcmContentDependencies: 'Abhängigkeiten',
  wcmContentApprove: 'Freigeben & Publizieren',

  create: 'Anlegen',
  rename: 'Umbenennen',
  cancel: 'Abbrechen'
});

CStudioAuthoring.Messages.registerBundle('forms', 'de', {
  new: 'Neu',
  expandAll: 'Alle aufklappen',
  collapseAll: 'Alle zuklappen',
  pageName: 'Name der Seite',
  location: 'Position',
  sectionValidation: '{0} von {1} Attributen mit geforderten Einschränkungen sind ungültig.',
  saveAndClose: 'Speichern und Schließen',
  saveAndCloseDraft: 'Zwischenspeichern',
  saveAndPreview: 'Speichern und Vorschau',
  save: 'Speichern',
  cancel: 'Abbrechen',
  close: 'Schließen',
  repeatAddAnother: 'Weiteres anfügen',
  repeatMoveUp: 'Nach oben',
  repeatMoveDown: 'Nach unten',
  repeatDelete: 'Löschen',
  errMissingRequirements:
    'Es kann erst gespeichert werden, wenn alle erforderlichen Felder ausgefüllt sind.',
  errSaveFailed: 'Fehler beim Speichern - bitte kontaktieren Sie Ihren Systemadministrator.',
  errOnRepeat: 'Fehler im Repeater: {0}',
  errFailedToLoadContent: 'Fehler beim Laden: {0}',
  errExpectedIndexXml: 'Fehler im Dateinamen: index.xml erwartet',
  ok: 'OK',
  yes: 'Ja',
  no: 'Nein',
  openType: 'Offener Typ',
  submit: 'Senden',
  loading: 'Lädt&hellip;',
  viewSample: 'Beispiel einblenden',
  hideSample: 'Beispiel ausblenden',
  clearCache: 'Cache löschen',
  continueEditing: 'Weiter bearbeiten',
  notification: 'Benachrichtigung',
  previewLoaded: 'Vorschau geladen.',

  copy: 'Kopieren',
  copyDescription:
    'Bitte markieren Sie alle Seiten, die Sie kopieren möchten.<br/>Beim Einfügen bleiben die Positionen der Seiten entsprechend erhalten.',
  page: 'Seite',
  loadingContents: 'Lädt...',
  cut: 'Ausschneiden',
  cutDescription:
    'Bitte markieren Sie alle Seiten, die Sie ausschneiden möchten.<br/>Beim Einfügen bleiben die Positionen der Seiten entsprechend erhalten.',

  create: 'Anlegen',
  newFolderTitle: 'Neues Verzeichnis anlegen',
  newFolderBody: 'Bitte geben Sie einen Namen für das Verzeichnis ein.',
  newFolderLabel: 'Name:',
  newFolderUpdating: 'Verzeichnis wird angelegt...',

  chooseContentType: 'Auswahl des Content-Typs',
  chooseContentTypeBody: 'In diesem Verzeichnis sind die folgenden Content-Typen verfügbar.',
  chooseContentTypeLabel: 'Content-Typ:',
  chooseContentTypePreview: 'Vorschau:',

  cancelDialogHeader: 'Crafter Studio',
  cancelDialogBody: 'Wollen Sie dieses Formular wirklich schließen ohne zu Speichern?',
  noContentTypes: 'In diesem Verzeichnis können keinerlei Content-Typen angelegt werden:',
  noTemplatesAssoc: 'Kein Template zugewiesen:',
  noTemplateAssocAdm:
    'Diesem Content-Typ ist kein Template zugewiesen. Klicken Sie <Speichern> um dennoch fortzufahren oder <Weiter bearbeiten> um ein Template zuzuweisen.',

  changeTemplateDialogTitle: 'Warnung: Änderung des Content-Typs',
  changeTemplateDialogSubTitle: 'Crafter Studio',
  changeTemplateDialogBody: 'Diese Aktion kann zu Datenverlust führen. Sind Sie sicher?',

  bulkPublishDialogTitle: 'Warnung: Massen-Publizierung',
  bulkPublishDialogBody:
    'Durch Massen-Publizierung werden alle Elemente samt Abhängigkeiten veröffentlicht, die dem angegeben Muster entsprechen.</br> Bitte versichern Sie sich, dass keine Inhalte unbeabsichtigt mit publiziert werden.',
  bulkPublish: 'Massen-Publizierung',
  bulkPublishPathToPublish: 'Pfad für Massen-Publizierung',
  bulkPublishPublishingEnv: 'Umgebung',
  bulkPublishPublish: 'Publizieren',

  historyDialogTitle: 'Versionshistorie',
  historyDialogSubTitle: 'Historie von:',
  historyDialogTableRowVersion: 'Versionsdatum',
  historyDialogTableRowTime: 'Bearbeitet am',
  historyDialogTableRowEditBy: 'Bearbeitet von',
  historyDialogTableRowComment: 'Kommentar',
  historyDialogTableRowActions: 'Aktionen',
  historyDialogRevert: 'Wiederherstellen',
  historyDialogLoadingWait: 'Lädt, bitte warten&hellip;',
  historyDialogNoVersionsFound: 'Keine Versionen gefunden.',
  historyDialogUnable: 'Die Versionshistorie konnte nicht geladen werden.',
  historyDialogTryAgain: 'Noch einmal versuchen',
  historyDialogViewFileMessage: 'Diese Version ansehen',
  historyDialogCompareFileMessage: 'Vergleich mit aktueller Version',
  historyDialogRevertFileMessage: 'Diese Version wiederherstellen',
  historyDialogCompare: 'Vergleichen',

  deleteDialogTitle: 'Löschen',
  deleteDialogSubTitle:
    'Ausgewählte Elemente werden zusammen mit ihren untergeordneten Elementen gelöscht. Bitte überprüfen Sie abhängige Elemente vor dem Löschen, da diese mit fehlerhaften Linkverweisen enden.',
  deleteDialogSetLink: 'Setze alles auf "Jetzt"',
  deleteDialogPage: 'Seite',
  deleteDialogDelete: 'Löschen',
  deleteDialogNow: 'Jetzt',
  deleteDialogFeedBack:
    'Abhängigkeiten müssen ebenfalls ausgewählt werden, um fortfahren zu können.',
  deleteDialogNoItemsSelected: 'Es sind keine Elemente ausgewählt.',
  deletedTitle: 'Auswahl gelöscht',
  deletedMessage: 'Die gewählten Elemente wurden gelöscht und werden in Kürze entfernt.',

  deleteSubmitDialogTitle: 'Zum Löschen einreichen',
  deleteSubmitDialogTime: 'Wann sollen die ausgewählten Elemente gelöscht werden?',
  deleteSubmitEmailMe: 'Benachrichtung per E-Mail erhalten, wenn die Elemente gelöscht wurden',
  deleteSubmitDialogAsSoon: 'So schnell wie möglich.',

  approveDialogTitle: 'Freigabe zum Publizieren',
  approveDialogSubTitle:
    'Ausgewählte Dateien werden veröffentlicht. Harte Abhängigkeiten werden automatisch berücksichtigt. Weiche Abhängigkeiten sind optional und Sie können auswählen, welche einbezogen werden sollen.',
  approveDialogWarning:
    'WARNUNG: Für die ausgewählten Elemente wurde bereits ein anderer Publizierungszeitpunkt definiert.',
  dependenciesDialogTitle: 'Abhängigkeiten',
  dependenciesDialogSubTitle: 'Die Abhängigkeiten werden angezeigt für:',
  dependsOn: 'Referenziert auf diese Elemente',
  dependsOnMe: 'Wird von folgenden Elementen referenziert',
  selectDeps: 'Richtung:',
  dependenciesDialogItem: 'Element',
  approveDialogPage: 'Seite',
  approveDialogOriginalSchedule: 'Ursprünglicher Zeitpunkt',
  approveDialogSubmissionComment: 'Kommentar',
  approveDialogSelectedScheduling: 'Zeitplan für gewähltes Element',
  approveDialogItemsLiveNow: 'Artikel sollten jetzt veröffentlicht werden.',
  approveDialogItemsLiveDate:
    'Die Artikel sollten zu einem bestimmten Datum und einer bestimmten Uhrzeit veröffentlicht werden:',
  approveDialogPublishContent: 'Elemente publizieren',
  approveDialogPublishingOptions: 'Veröffentlichungsziel',
  approveDialogBroadcastUpdate: 'Veröffentlichung bekannt geben',

  requestApproveDialogTitle: 'Publizierung anfordern',
  requestApproveDialogSubTitle: 'Wann möchten Sie die markierten Artikel veröffentlichen?',
  requestApproveDialogEmailMe:
    'Benachrichtung per E-Mail erhalten, wenn die Elemente zum Publizieren freigegeben wurden.',

  itemsForPublish: 'Zu veröffentlichende Elemente',
  selectAll: 'Wählen Sie Alle',
  hardDependencies: 'Harte Abhängigkeiten',
  submissionMandatory: 'Vorlage obligatorisch',
  softDependencies: 'Weiche Abhängigkeiten',
  submissionOptional: 'Einreichung optional',
  showAllDependencies: 'Alle Abhängigkeiten anzeigen',
  changesSelectionItems:
    'Änderungen bei der Auswahl der zu veröffentlichenden Elemente erfordern eine Neuberechnung aller Abhängigkeiten.',
  loadingDependencies: 'Abhängigkeiten werden geladen, bitte warten ...',

  childItemsText: 'Untergeordnete Elemente',
  willGetDeleted: 'Wird gelöscht',
  dependendtItems: 'Abhängige Gegenstände',
  brokenItems: 'Wird gebrochene Referenzen haben',
  deleteItems: 'Elemente löschen',
  uploadingDepenedents: 'Updating dependents, please wait...',

  newContTypeDialogTitle: 'Neuen Content-Typ anlegen',
  newContTypeDialogDisplayLabel: 'Label',
  newContTypeDialogContentTypeName: 'Name',
  newContTypeDialogType: 'Typ',
  component: 'Komponente',
  newContTypeDialogLabelMsg: 'Vergeben Sie ein Label für den neuen Content-Typ',
  newContTypeDialogContentTypeNamelMsg:
    'Vergeben Sie einen System-internen Namen für den neuen Content-Typ',
  newContTypeDialogTypeMsg: 'Wählen Sie den Typ für den neuen Content-Typ',

  adminHelpDialogTitle: 'Feld Inhalt',

  adminKeyValDialogTitle: 'Key-Values',
  adminKeyValDialogKey: 'Key',
  adminKeyValDialogValue: 'Value',
  addAnother: 'Weiteren hinzufügen',

  supportedChannelsDialogLabel: 'Label',
  supportedChannelsDialogName: 'Name',
  supportedChannelsDialogSize: 'Größe',

  setStatedDialogTitle: 'Wählen Sie den Status',
  setStatedDialogSetStates: 'Status setzen',
  setStatedDialogSystemProcessing: 'Systemverarbeitung',

  setQueueDialogTitle: 'Wählen Sie den Status',
  setDeploymentQueue: 'Deployment Queue',
  setDeploymentEndpoints: 'Deployment Ziele',
  setDeploymentJobs: 'Deployment Jobs',
  setQueueDialogCancelDeployment: 'Deployment abbrechen',
  setQueueDialogSystemProcessing: 'Systemverarbeitung',

  deploymentTabSelectEndpoint: 'Wählen Sie das Ziel',
  deploymentTabEndpointProperty: 'Eigenschaft',
  deploymentTabEndpointValue: 'Wert',

  currentPage: 'Aktuelle Seite',

  wcmContentSavedAsDraft:
    'Element wurde als ENTWURF gespeichert. Da nicht alle Pflichtfelder ausgefüllt sein müssen, kann es zu Fehlern in der Vorschau kommen.',

  previewInitiated: 'Vollständige Synchronisation des Vorschau-Servers initialisiert.',
  synchronizationRepo: 'Synchronisation aus Repository initialisiert.',

  /*Preview*/
  previewToolsTitle: 'Werkzeuge',
  inContextEditing: 'Im-Kontext Bearbeitung',
  pageComponents: 'Komponenten',
  publishingChannel: 'Gerätevorschau',
  inContextEdit: 'Im-Kontext Bearbeitung',

  /*Error*/
  legacyFormNoSupported: 'Der alte Formular Server wird nicht mehr unterstützt.',
  loadContentsError:
    'Inhalte konnten nicht geladen werden. Bitte schließen Sie diesen Dialog und versuchen es noch einmal.',
  taxonomyError: 'Keine Taxonomie-Einträge verfügbar für',
  getDomainNameError: 'Service.getDomainName ist veraltet.',
  changeContTypeError: 'Fehler beim Ändern des Content-Typs.',
  notImplemented: 'Nicht implementiert.',
  timeFormatError: 'ist kein gültiges Format. Bitte geben Sie eine valide Zeit an.',
  localStoreExceeded: 'Ihr lokaler Speicher ist voll.',
  invalidFormat: 'ist kein gültiges Format. Bitte geben Sie eine valide Zeit an.',
  addMoreItemsError:
    'Es können keine weiteren Elemente hinzugefügt werden. Bitte entfernen Sie zunächst ein Element aus der Liste bevor Sie es erneut probieren.',
  imgReq: 'Bild-Beschreibung ist notwendig.',
  datasourceNotImageManager: 'Die konfigurierte Datasource ist keine Bildverwaltung.',
  noDatasourceAssociated: 'Mit diesem Editor wurde keine Data Source verknüpft.',
  notAComponent: ' ist keine Komponente oder besitzt keine Einträge',
  unableLoad: 'Fehler beim Laden ',
  failure: 'Fehler.',
  loadFormDefError: 'Fehler beim Laden der Formular Definition.',
  loadModelError: 'Fehler beim Laden des Models.',
  controllerError: 'Kein Controller gefunden',
  notExist: ' existiert nicht.',
  translationSubmitted: 'Übersetzung eingereicht.',
  numberPerPage: 'Bitte geben Sie eine Anzahl für Einträge pro Seite an.',
  revertError: 'Zurücksetzen ist fehlgeschlagen.',
  legacyError: 'Der alte Formular Server wird nicht mehr unterstützt.',
  contentTypesEmpty:
    'Es gibt keine Content-Typen, die unter dem konfigurierten Pfad angelegt werden können.',
  componentCategoriesError: 'Es sind keine Kategorien zum Anlegen verfügbar.',
  pluginError:
    'Es wurden Probleme mit Ihrer Plugin-Konfiguration gefunden. Die folgenden Eigenschaften fehlen:',
  pluginErrorSolution:
    "<a id='siteConfigURL'>Gehen Sie zu <a id='siteConfigURL'> [Site-Konfigurationsseite] </a> und wählen Sie in der Dropdown-Liste die Option 'Site-Konfigurations-Tools' aus, um die Datei zu bearbeiten.",
  control: 'Steuerung: ',
  datasource: 'Datenquelle: ',
  propertyMessage: ' Eigenschaft fehlt.',
  propertiesMessage: ' Eigenschaften fehlen.'
});

CStudioAuthoring.Messages.registerBundle('search', 'de', {
  searchInput: 'Suche',
  numResults: 'Anzahl der Ergebnisse',
  selectAll: 'Alle auswählen',
  filters: 'Filter',
  relevance: 'Relevanz',
  asc: 'Aufsteigend',
  desc: 'Absteigend',
  moreRelevance: 'Wichtigste zuerst',
  lessRelevance: 'Weniger relevant zuerst',
  sortOrder: 'Sortierreihenfolge',
  sortBy: 'Sortiere nach',
  name: 'Name',
  images: 'Bilder',
  videos: 'Videos',
  width: 'Breite',
  height: 'Höhe',
  'content-type': 'Content-Typ',
  'mime-type': 'MIME-Typ',
  'last-edit-date': 'Letztes Bearbeitungsdatum',
  size: 'Größe',
  today: 'heute',
  'in-last-day': 'Gestern',
  'in-last-week': 'Letzte Woche',
  'over-a-month-ago': 'Vor über einem Monat',
  'over-six-months-ago': 'Vor über sechs Monaten',
  'over-a-week-ago': 'Vor über einer Woche',
  'over-a-year-ago': 'Vor über einem Jahr',
  paginationFirst: 'Erste Seite',
  paginationPrev: 'Zurück',
  paginationNext: 'Weiter',
  paginationLast: 'Letzte Seite',
  seeMore: 'Mehr',
  seeLess: 'Weniger',
  under: 'Unter',
  above: 'und über',
  errorMessage:
    'Bei der Suche ist ein Problem aufgetreten. Wenden Sie sich an den Administrator, falls das Problem weiterhin besteht.',
  clear: 'Zurücksetzen',
  apply: 'Anwenden'
});

CStudioAuthoring.Messages.registerBundle('browse', 'de', {
  labelUrl: 'URL',
  labelType: 'Typ',
  labelAddClose: 'Hinzufügen & Schließen',
  labelAddLink: 'Link hinzufügen',
  labelClone: 'Klonen',
  selectAll: 'Alles auswählen',
  clearAll: 'Auswahl aufheben',
  uploadLabel: 'Upload',
  notification: 'Benachrichtigung',
  lookUpChildError: 'Fehler im Callback der Suche nach: ',
  lookUpParentError: 'Fehler im Context der Suche nach: ',
  loading: 'Laden',
  serverError: 'Server Fehler',
  noBrowseResults: 'Es existieren keine Dateien in diesem Pfad.',
  noSearchResults: 'Keine Ergebnisse.',
  showMore: 'Mehr anzeigen',
  400: 'Ungültige CMIS Parameter. Ungültige CMIS Konfiguration (Hostname, Port, etc.). Bitte kontaktieren Sie Ihren Administrator.',
  401: 'CMIS Zugriff verweigert: Ungültiger Benutzername oder ungültiges Passwort in der CMIS Konfiguration gesetzt. Bitte kontaktieren Sie Ihren Administrator.',
  404: 'CMIS Pfad nicht gefunden.',
  408: 'CMIS Server - Timeout.',
  500: 'Interner Server Fehler.',
  503: 'CMIS nicht erreichbar.'
});

CStudioAuthoring.Messages.registerBundle('contentTypes', 'de', {
  contenttypes: 'Content-Typen',
  bulkoperations: 'Massenbearbeitung',
  workflowjobs: 'Workflow Jobs',
  workflowstates: 'Workflow Status',
  logginglevels: 'Logging Levels',
  logconsole: 'Log Konsole',
  publishing: 'Publizieren',
  status: 'Status',
  audit: 'Audit',
  groups: 'Gruppen',
  contentTypes: 'Content-Typen',
  configuration: 'Konfiguration',
  workflowJobs: 'Workflow Jobs',
  workflowStates: 'Workflow Status',
  loggingLevels: 'Logging Levels',
  logConsole: 'Log Konsole',
  previewsync: 'Vorschau Sync',
  syncfromrepository: 'Sync aus Repository',
  deploymentQueues: 'Deployment Queue',
  label: 'Content-Typen',
  openExistingType: 'Content-Typ bearbeiten',
  createNewType: 'Neuen Content-Typ erstellen',
  save: 'Speichern',
  cancel: 'Abbrechen',
  create: 'Erstellen',
  close: 'Schließen',
  saved: 'Speichern',
  clearVal: 'Wert zurücksetzen',
  saveFailed: 'Speichern fehlgeschlagen.',
  formSection: 'Formularabschnitt',
  repeatingGroup: 'Sich wiederholende Gruppe',
  minOccurs: 'Minimale Anzahl',
  maxOccurs: 'Maximale Anzahl',
  formBasics: 'Grundeinstellungen',
  formTitle: 'Titel',
  description: 'Beschreibung',
  objectType: 'Objekt-Typ',
  contentType: 'Content-Typ',
  datasourceBasics: 'Data Source - Grundeinstellungen',
  title: 'Titel',
  name: 'Name',
  properties: 'Eigenschaften',
  sectionBasics: 'Abschnitt - Grundeinstellungen',
  variableName: 'Name / Variablenname',
  iceGroup: 'ICE Gruppe',
  fieldBasics: 'Allgemeines',
  defaultValue: 'Standardwert',
  help: 'Hilfetext',
  constraints: 'Beschränkungen',
  propertiesExplorer: 'Einstellungen',
  controls: 'Controls',
  datasources: 'Data Sources',
  defaultOpen: 'Standardmäßig geöffnet',
  showInNav: 'Zeige in Navigation',
  descriptorMapper: 'Descriptor Mapper',
  previewImage: 'Vorschau-Bild ',
  config: 'Konfiguration',
  controller: 'Controller',

  warning: 'Warnung',
  warningBody: 'Eine Änderung dieses Wertes kann zu falschen Links führen.',
  warningViewDeps: 'Um möglicherweise betroffene Links anzuzeigen, klicken Sie bitte ',
  warningLink: 'hier',

  notification: 'Benachtichtigung',
  deploymentCanceled: 'Deployment abgebrochen.',

  createTemplate: 'Neues Template',
  templateFilename: 'Bitte vergeben Sie einen Namen für das Template',

  /*Controls*/
  textArea: 'Textarea',
  linkTextarea: 'Link Textarea',
  richTextEditor: 'Rich Text Editor (TinyMCE 2)',
  rteTinyMCE5: 'Rich Text Editor (TinyMCE 5)',
  input: 'Eingabefeld',
  numericInput: 'Numerische Eingabe',
  uuid: 'UUID',
  linkInput: 'Link Eingabefeld',
  dropdown: 'Dropdown',
  linkedDropdown: 'Verlinkte Dropdown',
  dateTime: 'Datum / Uhrzeit',
  time: 'Uhrzeit',
  checkBox: 'Checkbox',
  groupedCheckboxes: 'Gruppierte Checkboxen',
  itemSelector: 'Elementauswahl',
  image: 'Bild',
  video: 'Video',
  label: 'Label',
  pageOrder: 'Platzierung in Navigation',
  fileName: 'Dateiname',
  autoFilename: 'Automatisch vergebener Dateiname',
  forceHTTPS: 'HTTPS erzwingen',
  disabled: 'Deaktiviert',
  flash: 'Flash',
  internalName: 'Interner Name',
  basicContentTypeProp: 'Content-Typ Grundeinstellungen',
  publishStarted: 'Publizierung wurde gestartet.',

  /*Datasources */
  childContent: 'Komponenten',
  embeddedContent: 'Eingebetteter Inhalt',
  imageUploadedDesktop: 'Bilder hochladen',
  WebDAVUploadImage: 'Bilder in WebDav Repository hochladen',
  WebDAVUploadVideo: 'Videos in WebDav Repository hochladen',
  imageWebDavRepository: 'Bilder aus WebDav Repository',
  videoWebDavRepository: 'Videos aus WebDav Repository',
  fileWebDavRepository: 'Dateien aus WebDav Repository',
  fileUploadedWebDavRepository: 'Dateien in WebDav Repository hochladen',
  S3UploadImage: 'Bilder in S3 Repository hochladen',
  S3UploadVideo: 'Videos in S3 Repository hochladen',
  imageS3Repository: 'Bilder aus S3 Repository',
  videoS3Repository: 'Videos aus S3 Repository',
  videos3Transcoding: 'Videotranscodierung aus dem S3-Repository',
  fileS3Repository: 'Dateien aus S3 Repository',
  fileUploadedS3Repository: 'Dateien in S3 Repository hochladen',
  DAMImage: 'DAM Bild Flickr',
  fileUploadedDesktop: 'Dateien hochladen',
  flashUploadedDesktop: 'Flash-Videos hochladen',
  videoUploadedDesktop: 'Videos hochladen',
  videoBrowse: 'Videos aus Repository',
  videoCMISRepository: 'Videos aus CMIS Repository',
  staticKeyValuePairs: 'Statische Key-Value Paare',
  configuredListOfPairs: 'Konfigurierte Liste',
  siteComponent: 'Key-Value Paare aus einer Komponente',
  fileBrowse: 'Projekt-Dateien',
  hubspotForms: 'Hubspot Formular',
  imageFromRepository: 'Bilder aus Repository',
  imageFromCMISRepository: 'Bilder aus CMIS Repository',
  CMISRepository: 'Datei aus dem CMIS-Repository',
  CMISUpload: 'Datei ins CMIS-Repository hochgeladen',
  CMISUploadImage: 'Image wurde in das CMIS-Repository hochgeladen',
  CMISUploadVideo: 'In CMIS-Repository hochgeladenes Video',
  salesforceCampaigns: 'Salesforce Kampagnen',
  treeContent: 'Baumstruktur',

  /*Properties*/
  size: 'Größe',
  maxLength: 'Maximale Länge',
  width: 'Breite',
  height: 'Höhe',
  autoGrow: 'Auto wachsen',
  allowResize: 'Größenänderung zulassen',
  forceRootBlockP: '<p>-Tag als Root Blockelement erzwingen',
  forcePNewLines: '<p>-Tag als Zeilenumbruch erzwingen',
  forceBRNewLines: '<br>-Tag als Zeilenumbruch verwenden',
  requireImageAlt: 'alt-Tag für Bilder einfordern',
  supportedChannels: 'Unterstützte Kanäle',
  RTEConfiguration: 'RTE Konfiguration',
  imageManager: 'Bildverwaltung',
  videoManager: 'Videoverwaltung',
  showDate: 'Zeige Datum',
  showTime: 'Zeige Uhrzeit',
  showClear: "Zeige 'Wert zurücksetzen'",
  setNowLink: "Zeige 'Jetzt' Link",
  populated: 'Vorausgefüllt',
  allowPastDate: 'Erlaube Werte in der Vergangenheit',
  populateExpression: 'Standardwert',
  useCustomTimezone: 'Eigene Zeitzone',
  readonly: 'Nur lesbar',
  readonlyOnEdit: 'Nach dem Anlegen nur noch lesbar',
  datasource: 'Data Source',
  showSelectAll: 'Zeige "Alles auswählen"',
  allowEmptyValue: 'Erlaube leere Werte',
  thumbnailWidth: 'Breite des Vorschau-Bildes',
  thumbnailHeight: 'Höhe des Vorschau-Bildes',
  displaySize: 'Display Größe',
  text: 'Text',
  minSize: 'Min. Größe',
  maxSize: 'Max. Größe',
  itemManager: 'Data Sources',
  disableFlatteningSearch: 'Zuklappen während der Suche deaktivieren',
  singleValueFilename: 'Einfache Dateienamen (Rückwärtskompatibilität)',
  columns: 'Spalten',
  rows: 'Zeilen',
  dataType: 'Datentyp',
  listName: 'Listen-Name',
  repositoryPath: 'Repository-Pfad',
  studioPath: 'Studio-Pfad',
  repositoryId: 'Repository-ID',
  browsePath: 'Browse Pfad',
  allowedOperations: 'Erlaubte Operationen',
  clone: 'Klonen',
  link: 'Verlinken',
  cloneAndLink: 'Klonen und Verlinken',
  string: 'String',
  integer: 'Integer',
  float: 'Float',
  date: 'Date',
  HTML: 'HTML',
  options: 'Optionen',
  showKeys: 'Zeige keys',
  taxonomyName: 'Taxonomy Name',
  defaultType: 'Standardtyp',
  displayTemplate: 'Template',
  noTemplateRequired: 'Keine Vorlage erforderlich',
  mergeStrategy: 'Merge Strategie',
  componentPath: 'Komponenten-Pfad',
  dependsOn: 'Hängt ab von',
  profileId: 'Profil-ID',
  path: 'Pfad',
  type: 'Typ',
  quickCreate: 'Schnell erstellen',
  showQuickCreate: 'In Quick Create anzeigen',
  destinationPath: 'Zielpfadmuster',
  inputProfileId: 'Eingabeprofil-ID',
  outputProfileId: 'Ausgabeprofil-ID',
  postfixes: 'Postfixes',
  enableCreateNew: "Zeige 'Neu anlegen'",
  enableBrowseExisting: "Zeige 'Auswählen'",
  enableSearchExisting: "Zeige 'Suchen'",
  useSearch: 'Suche verwenden',

  /*Restrictions*/
  required: 'Erforderlich',
  minimumSelection: 'Mindestauswahl',
  matchPattern: 'Regulärer Ausdruck',
  allowDuplicate: 'Duplikate erlauben',

  /*Values*/
  noDatasources: 'Keine passenden Data Sources verfügbar',
  editMessage: 'Bearbeiten - Nachricht',
  setMessage: 'Anlegen - Nachricht',

  /*States Workflow*/
  setStatedTabID: 'ID',
  setStatedTabState: 'Status',
  setStatedTabSystemProcessing: 'In Bearbeitung',
  setStatedTabSelectAll: 'Alles auswählen',
  false: 'False',
  true: 'True',

  /*Deployment Queues*/
  setQueueTabSelectAll: 'Alles auswählen',
  setQueueTabID: 'ID',
  setQueueTabPath: 'Pfad',
  setQueueTabOldPath: 'Alter Pfad',
  setQueueTabEnvironment: 'Umgebung',
  setQueueTabUser: 'Benutzer',
  setQueueTabState: 'Status',
  setQueueTabVersion: 'Version',
  setQueueTabAction: 'Aktion',
  setQueueTabScheduledDate: 'Geplantes Datum',
  setQueueTabContentTypeClass: 'Content-Typ Class',

  /*Jobs Workflow*/
  jobWorkflowTabAct: 'Handlung',
  jobWorkflowTabJobID: 'Job ID',
  jobWorkflowTabProcessName: 'Prozess Name',
  jobWorkflowTabCreatedDate: 'Erstellungsdatum',
  jobWorkflowTabModifiedDate: 'Bearbeitungsdatum',
  jobWorkflowTabSiteId: 'Projekt ID',
  jobWorkflowTabItemsInJob: 'Elemente<br/>im Job',
  jobWorkflowTabProperties: 'Eigenschaften',
  jobWorkflowTabStatus: 'Status',

  /*Loggin Levels*/
  logginLevelsTabLogger: 'Logger',
  logginLevelsTabCurrentLevel: 'Aktuelles Level',
  logginLevelsTabChangeLevel: 'Neues Level setzen',
  debug: 'debug',
  warn: 'warn',
  info: 'info',
  error: 'error',

  /*Configuration*/
  confTabSelectConf: 'Konfiguration wählen',
  confTabConfigurations: 'Konfigurationen',
  confTabConfDesc: 'Liste aller Konfigurationsdateien',
  confTabContextualNavigationConf: 'Kontextbezogene Navigation',
  confTabContextualNavigationConfDesc:
    'Definiert alle Einträge in kontextbezogenen Navigationsleisten',
  confTabSidebarConf: 'Seitenleiste',
  confTabSidebarConfDesc: 'Definiert alle Einträge in der Seitenleiste',
  confTabEndpointsConf: 'Endpunkte',
  confTabEndpointsConfDesc: 'Definiert eine Liste aller verfügbarer Endpunkte',
  confTabDevEnvironmentConf: 'Entwicklungsumgebung',
  confTabDevEnvironmentConfDesc: 'Konfiguration der Entwicklungsumgebung',
  confTabTargetsConf: 'Targets',
  confTabTargetsConfDesc: 'Definiert eine Liste von Targets für Data Sources',
  confTabRTEConf: 'Rich-Text Editor (RTE)',
  confTabRTEConfDesc: 'Konfiguriert Profile für Rich Text Editoren',
  confTabRTEtMCE5Conf: 'RTE (TinyMCE 5) konfiguration',
  confTabRTEtMCE5ConfDesc: 'Definiert Rich Text Editors-Konfigurationen im Formular',
  confTabCodeEditorConf: 'Konfiguration des Code-Editors',
  confTabCodeEditorConfDesc: 'Definiert Code-Editor-Konfigurationen',
  confTabPreviewAssetConf: 'Vorschau von Elementen',
  confTabPreviewAssetConfDesc: 'Definiert eine Liste von editierbaren Elementen basierend auf XML',
  confTabPreviewComponentsConf: 'Vorschau von Komponenten',
  confTabPreviewComponentsConfDesc:
    'Definiert eine Liste von Komponenten, die dynamisch via Drag-and-Drop in der Vorschau angelegt werden können',
  confTabPreviewPanelConf: 'Vorschau Werkzeuge',
  confTabconfTabPreviewPanelConfDesc: 'Definiert die Werkzeugleiste für die Vorschau',
  confTabPersonasConf: 'Personas',
  confTabPersonasConfDesc:
    'Definiert eine Liste von Personas, die in der Vorschau zur Verfügung stehen',
  confTabNotificationConf: 'Benachrichtigungen',
  confTabNotificationConfDesc:
    'Konfiguriert alle automatischen Benachrichtigungen für den Workflow ',
  confTabPermissionsMappings: 'Berechtigungen',
  confTabPermissionsMappingsDesc: 'Definiert Berechtigungen jeder Rolle auf den jeweiligen Pfad',
  confTabRoleMappings: 'Rollen',
  confTabRoleMappingsDesc: 'Definiert Benutzerrollen im Projekt',
  confTabSiteConfiguration: 'Projekt Konfiguration',
  confTabSiteConfigurationDesc: 'Definiert allgemeine Projekteinstellungen',
  confTabSiteConf: 'Projekt Administration',
  confTabSiteConfDesc: 'Konfiguriert administrative Werkzeuge im Projekt',
  confTabWorkflowConf: 'Workflow',
  confTabWorkflowConfDesc: 'Definiert den Workflow für das Projekt',
  confCacheCleared: 'Konfigurationsdateien neu eingelesen.',
  confTabTargetingConfiguration: 'Targeting',
  confTabTargetingConfigurationDesc: 'Konfiguriert Targeting Profile in Crafter Studio',
  confTabEnvironmentConfiguration: 'Umgebungen',
  confTabEnvironmentConfigurationDesc:
    'Konfiguriert alle Umgebungen, in die publiziert werden kann',
  confTabCMISConfiguration: 'CMIS-Schnittstellen',
  confTabCMISConfigurationDesc:
    'In dieser Datei werden alle im Projekt verwendeten CMIS-Schnittstellen konfiguriert',
  confTabEngineSiteConfiguration: 'Crafter Engine',
  confTabEngineSiteConfigurationDesc: 'Konfigurationsdatei für Crafter Engine',
  confTabEngineSiteAppContextConfiguration: 'Crafter Engine Application Context',
  confTabEngineSiteAppContextConfigurationDesc: 'ApplicationContext Datei für Crafter Engine',

  /* Image */
  constraintsError: 'Das Bild entspricht nicht den geforderten Maßen',
  sizeError: 'Das Bild ist kleiner als die geforderte Mindestgröße',
  fileNotImage:
    'Die hochgeladene Datei ist fehlerhaft oder entspricht keinem der unterstützten Bildformate',
  loadImageError:
    'Fehler beim Laden des Bildes. Bitte versuchen Sie es erneut oder wählen ein anderes Bild',

  /*Postfixes*/
  iDescription: 'Für eine Ganzzahl',
  sDescription: 'Für die Zeichenfolge',
  lDescription: 'Für eine lange Ganzzahl',
  tDescription: 'Für mehrere Wörter oder Token',
  bDescription: 'Für Boolean (wahr oder falsch)',
  fDescription: 'Für Gleitkommazahl',
  dDescription: 'Für lange Gleitkommazahlen',
  dtDescription: 'Für Datum im Datumsformat ISO 8601',
  toDescription: 'Für die Zeit im Format HH: mm: ss',
  htmlDescription: 'Für Text mit HTML-Tags',
  oDescription: 'Zum Objekt',
  enDescription: 'Für mehrere Wörter oder Token',
  txtDescription: 'Für mehrere Wörter oder Token',

  /* Errors */
  error: 'Fehler',
  errorTitle: '. Bitte vergeben Sie Titel für alle Attribute und Data Sources.',
  postfixError: 'Modellfelder benötigen ihren jeweiligen Datentyp postfix: ',
  optionsPostfixError: 'Optionen sind ',
  optionPostfixError: 'Option ist',
  andPostfixError: 'und',
  errorName: '. Bitte vergeben Sie einen Variablennamen für: ',
  contentTypeNotFound: 'Der Content-Typ für die Komponente wurde nicht gefunden.',
  failConfig: 'Fehler beim Laden der Konfiguration.',
  noConfPathError: 'Der Pfad für die Konfiguration ist nicht definiert.',
  clearCacheError: 'Fehler beim Versuch, die Konfigurationsdateien neu einzulesen',
  endpointsError: 'Fehler beim Laden der Endpunkte.',
  jobsError: 'Fehler beim Laden der Jobs.',
  cancelDeploymentError: 'Fehler beim Versuch, das Deployment abzubrechen.',
  saveDateError:
    'Das Datumsfeld konnte nicht gespeichert werden. Bitte kontaktieren Sie Ihren Systemadministrator.',
  contentTypeModifiedWarn:
    'Der Content-Typ wurde bearbeitet. Sind Sie sicher, dass Sie Ihre Änderungen verwerfen möchten?',
  noPathSetError:
    'Der Pfad für die Data Source {DATASOURCENAME} ist ungültig. Bitte kontaktieren Sie Ihren Systemadministrator.',

  add: 'Hinzufügen',
  replace: 'Ersetzen',
  delete: 'Löschen',
  edit: 'Bearbeiten',
  createNew: 'Neu Anlegen',
  browseExisting: 'Auswählen',
  searchExisting: 'Suchen',

  /*help popover*/
  pattern: 'Muster',
  objectIdPattern: 'Fügt eine GUID ein.',
  yearPattern: 'Fügt das aktuelle Jahr ein (4-stelliges Jahr).',
  monthPattern: 'Fügt den aktuellen Monat ein (zweistelliger Monat des Jahres).',
  yyyyPattern: 'Fügt das aktuelle Jahr ein (4-stelliges Jahr).',
  mmPattern: 'Fügt den aktuellen Monat ein (zweistelliger Monat des Jahres).',
  ddPattern: 'Fügt den aktuellen Tag ein (zweistelliger Tag des Monats).'
});

CStudioAuthoring.Messages.registerBundle('targeting', 'de', {
  targeting: 'Targeting',
  clear: 'Zurücksetzen',
  apply: 'Anwenden',
  cancel: 'Abbrechen',
  userProps: 'Benutzereigenschaften'
});

CStudioAuthoring.Messages.registerBundle('dialogs', 'de', {
  upload: 'Hochladen',
  uploadSelect: 'Bitte wählen Sie eine Datei zum Hochladen aus',
  file: 'Datei',
  chooseFile: 'Datei wählen',
  noFileChosen: 'Keine Datei ausgewählt',
  uploadBtn: 'Hochladen',
  cancelBtn: 'Stornieren',
  uploading: 'Hochladen'
});
