/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.navigation.event.PerspectivePluginsChangedEvent;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
public class PerspectivesExplorer
implements IsWidget {
    View view;
    PerspectivePluginManager perspectivePluginManager;
    PlaceManager placeManager;
    ContentManagerI18n i18n;

    @Inject
    public PerspectivesExplorer(View view, PerspectivePluginManager perspectivePluginManager, PlaceManager placeManager, ContentManagerI18n i18n) {
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
        this.placeManager = placeManager;
        this.i18n = i18n;
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void show() {
        this.view.clear();
        List perspectivePlugins = this.perspectivePluginManager.getPerspectivePlugins();
        if (perspectivePlugins.isEmpty()) {
            this.view.showEmpty(this.i18n.getNoPerspectives());
        } else {
            perspectivePlugins.stream().sorted((p1, p2) -> p1.getName().compareToIgnoreCase(p2.getName())).forEach(p -> this.view.addPerspective(p.getName(), () -> this.onPerspectiveClick((Plugin)p)));
        }
    }

    public void onPerspectiveClick(Plugin plugin) {
        PlaceRequest placeRequest = new PathPlaceRequest(plugin.getPath()).addParameter("name", plugin.getName());
        this.placeManager.goTo(placeRequest);
    }

    public void onPerspectivePluginsChanged(@Observes PerspectivePluginsChangedEvent event) {
        this.show();
    }

    public static interface View
    extends UberView<PerspectivesExplorer> {
        public void clear();

        public void addPerspective(String var1, Command var2);

        public void showEmpty(String var1);
    }
}

