/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.cms.widget.PerspectivesExplorer;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.widget.NavTreeEditor;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.plugin.client.security.PluginController;
import org.uberfire.ext.plugin.client.widget.popup.NewPluginPopUp;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
@WorkbenchScreen(identifier="ContentExplorerScreen")
public class ContentExplorerScreen {
    public static final String SCREEN_ID = "ContentExplorerScreen";
    View view;
    NavigationManager navigationManager;
    PerspectivesExplorer perspectiveExplorer;
    NavTreeEditor navTreeEditor;
    NewPluginPopUp newPluginPopUp;
    PluginController pluginController;
    ContentManagerI18n i18n;
    Event<NotificationEvent> workbenchNotification;

    public ContentExplorerScreen() {
    }

    @Inject
    public ContentExplorerScreen(View view, NavigationManager navigationManager, PerspectivesExplorer perspectiveExplorer, NavTreeEditor navTreeEditor, NewPluginPopUp newPluginPopUp, PluginController pluginController, ContentManagerI18n i18n, Event<NotificationEvent> workbenchNotification) {
        this.view = view;
        this.navigationManager = navigationManager;
        this.perspectiveExplorer = perspectiveExplorer;
        this.navTreeEditor = navTreeEditor;
        this.newPluginPopUp = newPluginPopUp;
        this.pluginController = pluginController;
        this.i18n = i18n;
        this.workbenchNotification = workbenchNotification;
        this.view.init(this);
    }

    @AfterInitialization
    private void init() {
        this.navTreeEditor.setLiteralPerspective(this.i18n.capitalizeFirst(this.i18n.getPerspectiveResourceName()));
        this.view.setPerspectivesName(this.i18n.capitalizeFirst(this.i18n.getPerspectivesResourceName()));
        this.view.setMenusName(this.i18n.getContentExplorerMenus());
        this.view.setCreateName(this.i18n.getContentExplorerNew());
        this.view.setCreateMenuVisible(this.pluginController.canCreatePerspectives());
        this.view.addCreateMenuEntry(this.i18n.capitalizeFirst(this.i18n.getPerspectiveResourceName()), this::createNewPerspective);
        this.gotoPerspectives();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.i18n.getContentExplorer();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view;
    }

    public void createNewPerspective() {
        this.newPluginPopUp.show(PluginType.PERSPECTIVE_LAYOUT);
    }

    public void gotoPerspectives() {
        this.perspectiveExplorer.show();
        this.view.showPerspectives(this.perspectiveExplorer);
    }

    public void gotoMenus() {
        this.navTreeEditor.setNewGroupEnabled(true);
        this.navTreeEditor.setNewDividerEnabled(true);
        this.navTreeEditor.setNewPerspectiveEnabled(true);
        this.navTreeEditor.setMaxLevels(-1);
        this.navTreeEditor.setOnlyRuntimePerspectives(false);
        this.navTreeEditor.setGotoPerspectiveEnabled(true);
        this.navTreeEditor.setOnChangeCommand(this::onNavTreeChanged);
        this.navTreeEditor.edit(this.navigationManager.getNavTree());
        this.view.showMenus((IsWidget)this.navTreeEditor);
    }

    private void onNavTreeChanged() {
        this.navigationManager.saveNavTree(this.navTreeEditor.getNavTree(), () -> this.workbenchNotification.fire((Object)new NotificationEvent(this.i18n.getContentManagerNavigationChanged(), NotificationEvent.NotificationType.SUCCESS)));
    }

    public static interface View
    extends UberView<ContentExplorerScreen> {
        public void showPerspectives(IsWidget var1);

        public void showMenus(IsWidget var1);

        public void setPerspectivesName(String var1);

        public void setMenusName(String var1);

        public void setCreateName(String var1);

        public void setCreateMenuVisible(boolean var1);

        public void addCreateMenuEntry(String var1, Command var2);
    }
}

