/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import java.util.Arrays;
import java.util.Collections;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.cms.widget.PerspectivesExplorer;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class PerspectivesExplorerTest {
    @Mock
    PerspectivesExplorer.View viewM;
    @Mock
    PerspectivePluginManager perspectivePluginManagerM;
    @Mock
    PlaceManager placeManagerM;
    @Mock
    ContentManagerI18n i18nM;

    @Test
    public void showShouldDisplayEmptyMessage_whenNoPerspectivesAvailable() {
        ((PerspectivePluginManager)Mockito.doAnswer(invocationOnMock -> {
            ParameterizedCommand callback = (ParameterizedCommand)invocationOnMock.getArgumentAt(0, ParameterizedCommand.class);
            callback.execute(Collections.emptyList());
            return null;
        }).when((Object)this.perspectivePluginManagerM)).getPerspectivePlugins((ParameterizedCommand)Matchers.any());
        PerspectivesExplorer testedPE = new PerspectivesExplorer(this.viewM, this.perspectivePluginManagerM, this.placeManagerM, this.i18nM);
        testedPE.show();
        ((PerspectivesExplorer.View)Mockito.verify((Object)this.viewM)).clear();
        ((PerspectivesExplorer.View)Mockito.verify((Object)this.viewM)).showEmpty(Mockito.anyString());
    }

    @Test
    public void showShouldAddPerspectivesToViewInAlphabeticOrder_whenPerspectivesAvailable() {
        Plugin a = this.mkPlugin("a");
        Plugin b = this.mkPlugin("B");
        Plugin c = this.mkPlugin("cEE");
        ((PerspectivePluginManager)Mockito.doAnswer(invocationOnMock -> {
            ParameterizedCommand callback = (ParameterizedCommand)invocationOnMock.getArgumentAt(0, ParameterizedCommand.class);
            callback.execute(Arrays.asList(b, c, a));
            return null;
        }).when((Object)this.perspectivePluginManagerM)).getPerspectivePlugins((ParameterizedCommand)Matchers.any());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.viewM});
        PerspectivesExplorer testedPE = new PerspectivesExplorer(this.viewM, this.perspectivePluginManagerM, this.placeManagerM, this.i18nM);
        testedPE.show();
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).clear();
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).addPerspective((String)Matchers.eq((Object)"a"), (Command)Matchers.any());
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).addPerspective((String)Matchers.eq((Object)"B"), (Command)Matchers.any());
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).addPerspective((String)Matchers.eq((Object)"cEE"), (Command)Matchers.any());
    }

    private Plugin mkPlugin(String name) {
        return new Plugin(name, PluginType.PERSPECTIVE, null);
    }
}

