/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.explorer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.cms.screen.explorer.ContentExplorerScreen;
import org.dashbuilder.client.cms.widget.PerspectivesExplorer;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavTreeLoadedEvent;
import org.dashbuilder.client.navigation.event.PerspectivePluginsChangedEvent;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditorSettings;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditor;
import org.dashbuilder.navigation.NavTree;
import org.jboss.errai.common.client.api.IsElement;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class ContentExplorerScreenTest {
    @Mock
    ContentExplorerScreen.View view;
    @Mock
    NavigationManager navigationManager;
    @Mock
    PerspectivesExplorer perspectivesExplorer;
    @Mock
    NavTreeEditor navTreeEditor;
    @Mock
    NavItemEditorSettings navItemEditorSettings;
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    ContentManagerI18n i18n;
    @Mock
    NavTree navTree;
    ContentExplorerScreen contentExplorerScreen;

    @Before
    public void setUp() {
        Mockito.when((Object)this.navTreeEditor.getSettings()).thenReturn((Object)this.navItemEditorSettings);
        this.contentExplorerScreen = new ContentExplorerScreen(this.view, this.navigationManager, this.perspectivesExplorer, this.navTreeEditor, this.i18n, this.notificationEvent);
    }

    @Test
    public void testInitNoTreeAvailable() {
        this.contentExplorerScreen.init();
        ((ContentExplorerScreen.View)Mockito.verify((Object)this.view)).show((IsElement)this.perspectivesExplorer, (IsElement)this.navTreeEditor);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor, (VerificationMode)Mockito.never())).edit((NavTree)Mockito.any(NavTree.class));
    }

    @Test
    public void testInitTreeAlreadySet() {
        Mockito.when((Object)this.navigationManager.getNavTree()).thenReturn((Object)this.navTree);
        this.contentExplorerScreen.init();
        ((ContentExplorerScreen.View)Mockito.verify((Object)this.view)).show((IsElement)this.perspectivesExplorer, (IsElement)this.navTreeEditor);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).edit(this.navTree);
    }

    @Test
    public void testOnNavTreeLoaded() {
        this.contentExplorerScreen.init();
        this.contentExplorerScreen.onNavTreeLoaded(new NavTreeLoadedEvent(this.navTree));
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).edit(this.navTree);
    }

    @Test
    public void testOnPerspectivesChanged() {
        this.contentExplorerScreen.init();
        this.contentExplorerScreen.onPerspectivesChanged(new PerspectivePluginsChangedEvent());
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).edit((NavTree)Mockito.any(NavTree.class));
    }

    @Test
    public void testPerspectivesMaximized() {
        Mockito.when((Object)this.navTreeEditor.isExpanded()).thenReturn((Object)false);
        Mockito.when((Object)this.perspectivesExplorer.isExpanded()).thenReturn((Object)true);
        this.contentExplorerScreen.init();
        this.contentExplorerScreen.onPerspectivesExpanded();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setMaximized(false);
        ((PerspectivesExplorer)Mockito.verify((Object)this.perspectivesExplorer)).setMaximized(true);
    }

    @Test
    public void testPerspectivesExpanded() {
        Mockito.when((Object)this.navTreeEditor.isExpanded()).thenReturn((Object)true);
        Mockito.when((Object)this.perspectivesExplorer.isExpanded()).thenReturn((Object)true);
        this.contentExplorerScreen.init();
        this.contentExplorerScreen.onPerspectivesExpanded();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setMaximized(false);
        ((PerspectivesExplorer)Mockito.verify((Object)this.perspectivesExplorer)).setMaximized(false);
    }

    @Test
    public void testNavTreeEditorMaximized() {
        Mockito.when((Object)this.navTreeEditor.isExpanded()).thenReturn((Object)true);
        Mockito.when((Object)this.perspectivesExplorer.isExpanded()).thenReturn((Object)false);
        this.contentExplorerScreen.init();
        this.contentExplorerScreen.onNavTreeExpanded();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setMaximized(true);
        ((PerspectivesExplorer)Mockito.verify((Object)this.perspectivesExplorer)).setMaximized(false);
    }

    @Test
    public void testNavTreeEditorExpanded() {
        Mockito.when((Object)this.navTreeEditor.isExpanded()).thenReturn((Object)true);
        Mockito.when((Object)this.perspectivesExplorer.isExpanded()).thenReturn((Object)true);
        this.contentExplorerScreen.init();
        this.contentExplorerScreen.onNavTreeExpanded();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setMaximized(false);
        ((PerspectivesExplorer)Mockito.verify((Object)this.perspectivesExplorer)).setMaximized(false);
    }
}

