/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.cms.widget.PerspectivesExplorer;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavTreeLoadedEvent;
import org.dashbuilder.client.navigation.event.PerspectivePluginsChangedEvent;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditor;
import org.dashbuilder.navigation.NavTree;
import org.jboss.errai.common.client.api.IsElement;
import org.uberfire.backend.events.AuthorizationPolicySavedEvent;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
@WorkbenchScreen(identifier="ContentExplorerScreen")
public class ContentExplorerScreen {
    public static final String SCREEN_ID = "ContentExplorerScreen";
    View view;
    NavigationManager navigationManager;
    PerspectivesExplorer perspectiveExplorer;
    NavTreeEditor navTreeEditor;
    ContentManagerI18n i18n;
    Event<NotificationEvent> workbenchNotification;

    public ContentExplorerScreen() {
    }

    @Inject
    public ContentExplorerScreen(View view, NavigationManager navigationManager, PerspectivesExplorer perspectiveExplorer, NavTreeEditor navTreeEditor, ContentManagerI18n i18n, Event<NotificationEvent> workbenchNotification) {
        this.view = view;
        this.navigationManager = navigationManager;
        this.perspectiveExplorer = perspectiveExplorer;
        this.navTreeEditor = navTreeEditor;
        this.i18n = i18n;
        this.workbenchNotification = workbenchNotification;
        this.view.init(this);
    }

    @PostConstruct
    void init() {
        this.perspectiveExplorer.setOnExpandCommand(this::onPerspectivesExpanded);
        this.perspectiveExplorer.show();
        this.navTreeEditor.setOnExpandCommand(this::onNavTreeExpanded);
        this.navTreeEditor.setOnSaveCommand(this::onNavTreeSaved);
        this.navTreeEditor.getSettings().setLiteralPerspective(this.i18n.capitalizeFirst(this.i18n.getPerspectiveResourceName()));
        this.navTreeEditor.getSettings().setGotoPerspectiveEnabled(true);
        if (this.navTreeEditor.getNavTree() == null && this.navigationManager.getNavTree() != null) {
            this.navTreeEditor.edit(this.navigationManager.getNavTree());
        }
        this.view.show(this.perspectiveExplorer, (IsElement)this.navTreeEditor);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.i18n.getContentExplorer();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view;
    }

    public NavTreeEditor getNavTreeEditor() {
        return this.navTreeEditor;
    }

    public void createNewPerspective() {
        this.perspectiveExplorer.createNewPerspective();
    }

    void onPerspectivesExpanded() {
        this.perspectiveExplorer.setMaximized(this.perspectiveExplorer.isExpanded() && !this.navTreeEditor.isExpanded());
        this.navTreeEditor.setMaximized(!this.perspectiveExplorer.isExpanded() && this.navTreeEditor.isExpanded());
    }

    void onNavTreeExpanded() {
        this.perspectiveExplorer.setMaximized(this.perspectiveExplorer.isExpanded() && !this.navTreeEditor.isExpanded());
        this.navTreeEditor.setMaximized(!this.perspectiveExplorer.isExpanded() && this.navTreeEditor.isExpanded());
    }

    void onNavTreeLoaded(@Observes NavTreeLoadedEvent event) {
        NavTree navTree = event.getNavTree();
        this.navTreeEditor.edit(navTree);
    }

    void onPerspectivesChanged(@Observes PerspectivePluginsChangedEvent event) {
        NavTree navTree = this.navigationManager.getNavTree();
        this.navTreeEditor.edit(navTree);
    }

    void onNavTreeSaved() {
        this.workbenchNotification.fire((Object)new NotificationEvent(this.i18n.getContentManagerNavigationChanged(), NotificationEvent.NotificationType.SUCCESS));
    }

    void onAuthzPolicyChanged(@Observes AuthorizationPolicySavedEvent event) {
        NavTree navTree = this.navigationManager.getNavTree();
        this.navTreeEditor.edit(navTree);
        this.perspectiveExplorer.show();
    }

    public static interface View
    extends UberView<ContentExplorerScreen> {
        public void show(IsElement var1, IsElement var2);
    }
}

