/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.cms.widget.NewPerspectivePopUp;
import org.dashbuilder.client.navigation.event.PerspectivePluginsChangedEvent;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.plugin.client.security.PluginController;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
public class PerspectivesExplorer
implements IsElement {
    View view;
    PerspectivePluginManager perspectivePluginManager;
    PlaceManager placeManager;
    PluginController pluginController;
    NewPerspectivePopUp newPerspectivePopUp;
    ContentManagerI18n i18n;
    Command onExpandCommand;
    boolean expanded;

    @Inject
    public PerspectivesExplorer(View view, PerspectivePluginManager perspectivePluginManager, PluginController pluginController, NewPerspectivePopUp newPerspectivePopUp, PlaceManager placeManager, ContentManagerI18n i18n) {
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
        this.pluginController = pluginController;
        this.newPerspectivePopUp = newPerspectivePopUp;
        this.placeManager = placeManager;
        this.i18n = i18n;
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void setOnExpandCommand(Command onExpandCommand) {
        this.onExpandCommand = onExpandCommand;
    }

    public void show() {
        this.view.clear();
        this.view.setTitle(this.i18n.capitalizeFirst(this.i18n.getPerspectivesResourceName()));
        this.view.setNewMenuName(this.i18n.getContentExplorerNew());
        this.view.setNewMenuVisible(this.pluginController.canCreatePerspectives());
        this.view.setPerspectiveName(this.i18n.capitalizeFirst(this.i18n.getPerspectiveResourceName()));
        this.perspectivePluginManager.getPerspectivePlugins(perspectivePlugins -> {
            List<Plugin> filteredPlugins = perspectivePlugins.stream().filter(arg_0 -> ((PluginController)this.pluginController).canRead(arg_0)).sorted((p1, p2) -> p1.getName().compareToIgnoreCase(p2.getName())).collect(Collectors.toList());
            if (filteredPlugins.isEmpty()) {
                this.view.showEmpty(this.i18n.getNoPerspectives());
            } else {
                filteredPlugins.forEach(p -> this.view.addPerspective(p.getName(), () -> this.onPerspectiveClick((Plugin)p)));
            }
        });
        this.expand();
    }

    public void onPerspectiveClick(Plugin plugin) {
        PlaceRequest placeRequest = new PathPlaceRequest(plugin.getPath()).addParameter("name", plugin.getName());
        this.placeManager.goTo(placeRequest);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void expand() {
        if (!this.expanded) {
            this.expanded = true;
            this.view.setExpanded(true);
        }
    }

    public void collapse() {
        if (this.expanded) {
            this.expanded = false;
            this.view.setExpanded(false);
        }
    }

    public void expandOrCollapse() {
        if (this.expanded) {
            this.collapse();
        } else {
            this.expand();
        }
        if (this.onExpandCommand != null) {
            this.onExpandCommand.execute();
        }
    }

    public void setMaximized(boolean maximized) {
        this.view.setMaximized(maximized);
    }

    public void createNewPerspective() {
        this.newPerspectivePopUp.show();
    }

    public void onPerspectivePluginsChanged(@Observes PerspectivePluginsChangedEvent event) {
        this.show();
    }

    public static interface View
    extends UberElement<PerspectivesExplorer> {
        public void clear();

        public void setExpanded(boolean var1);

        public void setMaximized(boolean var1);

        public void setTitle(String var1);

        public void setNewMenuVisible(boolean var1);

        public void setNewMenuName(String var1);

        public void setPerspectiveName(String var1);

        public void addPerspective(String var1, Command var2);

        public void showEmpty(String var1);
    }
}

