/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Event;
import javax.inject.Inject;
import org.dashbuilder.client.cms.widget.PerspectivesExplorer;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Templated
public class PerspectivesExplorerView
implements IsElement,
PerspectivesExplorer.View {
    @Inject
    @DataField
    Span expandIcon;
    @Inject
    @DataField
    Span titleSpan;
    @Inject
    @DataField
    Div createDiv;
    @Inject
    @DataField
    Span createSpan;
    @Inject
    @DataField
    Anchor newPerspectiveAnchor;
    @Inject
    @DataField
    Div perspectivesDiv;
    PerspectivesExplorer presenter;

    public void init(PerspectivesExplorer presenter) {
        this.presenter = presenter;
    }

    @Override
    public void clear() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.perspectivesDiv);
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.perspectivesDiv.setHidden(!expanded);
        this.expandIcon.setClassName("uf-cms-expand-icon " + (expanded ? "fa fa-angle-down" : "fa fa-angle-right"));
    }

    @Override
    public void setMaximized(boolean maximized) {
        this.perspectivesDiv.setClassName("list-group list-view-pf " + (maximized ? "uf-cms-perspectives-maximized" : "uf-cms-perspectives-panel"));
    }

    @Override
    public void setTitle(String text) {
        this.titleSpan.setTextContent(text);
    }

    @Override
    public void setNewMenuVisible(boolean visible) {
        this.createDiv.setHidden(!visible);
    }

    @Override
    public void setNewMenuName(String text) {
        this.createSpan.setTextContent(text);
    }

    @Override
    public void setPerspectiveName(String text) {
        this.newPerspectiveAnchor.setTextContent(text);
    }

    private DivElement createItemDiv(Element[] items) {
        DivElement mi = Document.get().createDivElement();
        mi.setClassName("list-view-pf-main-info");
        mi.getStyle().setPaddingTop(5.0, Style.Unit.PX);
        mi.getStyle().setPaddingBottom(5.0, Style.Unit.PX);
        for (Element item : items) {
            mi.appendChild((Node)item);
        }
        DivElement gi = Document.get().createDivElement();
        gi.setClassName("list-group-item");
        gi.appendChild((Node)mi);
        return gi;
    }

    @Override
    public void addPerspective(String name, Command onClicked) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.getStyle().setCursor(Style.Cursor.POINTER);
        anchor.getStyle().setColor("black");
        anchor.getStyle().setProperty("fontSize", "larger");
        anchor.setInnerText(name);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                onClicked.execute();
            }
        });
        SpanElement icon = Document.get().createSpanElement();
        icon.getStyle().setMarginRight(10.0, Style.Unit.PX);
        icon.setClassName("pficon-virtual-machine");
        icon.getStyle().setProperty("fontSize", "larger");
        DivElement gi = this.createItemDiv(new Element[]{icon, anchor});
        this.perspectivesDiv.appendChild((org.jboss.errai.common.client.dom.Node)gi);
    }

    @Override
    public void showEmpty(String message) {
        SpanElement span = Document.get().createSpanElement();
        span.setInnerText(message);
        DivElement gi = this.createItemDiv(new Element[]{span});
        this.perspectivesDiv.appendChild((org.jboss.errai.common.client.dom.Node)gi);
    }

    @EventHandler(value={"expandIcon"})
    public void onExpandClick(ClickEvent event) {
        this.presenter.expandOrCollapse();
    }

    @EventHandler(value={"titleSpan"})
    public void onTitleClick(ClickEvent event) {
        this.presenter.expandOrCollapse();
    }

    @EventHandler(value={"newPerspectiveAnchor"})
    public void onNewPerspectiveClick(ClickEvent event) {
        this.presenter.createNewPerspective();
    }
}

