/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.io.IOException;
import java.util.ArrayList;
import org.dashbuilder.client.cms.screen.transfer.DataTransferPopUp;
import org.dashbuilder.client.cms.screen.transfer.DataTransferScreen;
import org.dashbuilder.transfer.DataTransferServices;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTransferScreenTest {
    @Mock
    private DataTransferScreen.View view;
    @Mock
    private DataTransferServices dataTransferServices;
    @Mock
    private DataTransferPopUp dataTransferPopUp;
    private DataTransferScreen dataTransferScreen;
    private CallerMock<DataTransferServices> dataTransferServicesCaller;

    @Before
    public void prepare() {
        this.dataTransferServicesCaller = new CallerMock((Object)this.dataTransferServices);
        this.dataTransferScreen = new DataTransferScreen(this.view, this.dataTransferPopUp, this.dataTransferServicesCaller);
    }

    @Test
    public void doExportTest() throws Exception {
        String path = "path";
        Mockito.when((Object)this.dataTransferServices.doExport()).thenReturn((Object)path);
        this.dataTransferScreen.doExport();
        ((DataTransferServices)Mockito.verify((Object)this.dataTransferServices)).doExport();
        ((DataTransferScreen.View)Mockito.verify((Object)this.view)).exportOK();
        ((DataTransferScreen.View)Mockito.verify((Object)this.view)).download(path);
    }

    @Test
    public void doExportFailureTest() throws Exception {
        IOException exception = new IOException();
        Mockito.when((Object)this.dataTransferServices.doExport()).thenThrow(new Throwable[]{exception});
        this.dataTransferScreen.doExport();
        ((DataTransferServices)Mockito.verify((Object)this.dataTransferServices)).doExport();
        ((DataTransferScreen.View)Mockito.verify((Object)this.view)).exportError((Throwable)exception);
    }

    @Test
    public void doImportTest() throws Exception {
        ArrayList list = new ArrayList();
        Mockito.when((Object)this.dataTransferServices.doImport()).thenReturn(list);
        this.dataTransferScreen.doImport();
        ((DataTransferServices)Mockito.verify((Object)this.dataTransferServices)).doImport();
        ((DataTransferScreen.View)Mockito.verify((Object)this.view)).importOK();
        ((DataTransferPopUp)Mockito.verify((Object)this.dataTransferPopUp)).show(list);
    }

    @Test
    public void doImportFailureTest() throws Exception {
        Exception exception = new Exception();
        Mockito.when((Object)this.dataTransferServices.doImport()).thenThrow(new Throwable[]{exception});
        this.dataTransferScreen.doImport();
        ((DataTransferServices)Mockito.verify((Object)this.dataTransferServices)).doImport();
        ((DataTransferScreen.View)Mockito.verify((Object)this.view)).importError((Throwable)exception);
    }
}

