/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.layout.editor;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.plugin.model.Plugin;

@Dependent
public class PerspectiveDragConfigModal
implements IsWidget {
    View view;
    PerspectivePluginManager perspectivePluginManager;
    PerspectiveTreeProvider perspectiveTreeProvider;
    Plugin selectedItem = null;
    Command onOk = null;
    Command onCancel = null;

    @Inject
    public PerspectiveDragConfigModal(View view, PerspectivePluginManager perspectivePluginManager, PerspectiveTreeProvider perspectiveTreeProvider) {
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
        this.perspectiveTreeProvider = perspectiveTreeProvider;
        this.view.init(this);
        this.view.setHelpText(ContentManagerConstants.INSTANCE.perspectiveDragComponentHelp());
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public View getView() {
        return this.view;
    }

    public void setOnOk(Command onOk) {
        this.onOk = onOk;
    }

    public void setOnCancel(Command onCancel) {
        this.onCancel = onCancel;
    }

    public Plugin getSelectedItem() {
        return this.selectedItem;
    }

    public void show(String selectedPerspectiveId) {
        this.view.clearItems();
        this.addItems(selectedPerspectiveId);
        this.view.show();
    }

    private void addItems(String selectedItemId) {
        this.perspectivePluginManager.getPerspectivePlugins(plugins -> {
            for (Plugin plugin : plugins) {
                String perspectiveName = this.perspectiveTreeProvider.getPerspectiveName(plugin.getName());
                this.view.addItem(perspectiveName, () -> this.onItemSelected(plugin));
                if (selectedItemId == null || !plugin.getName().equals(selectedItemId)) continue;
                this.view.setCurrentSelection(perspectiveName);
            }
        });
    }

    public void onItemSelected(Plugin plugin) {
        this.selectedItem = plugin;
        this.view.setCurrentSelection(this.selectedItem.getName());
    }

    void onOk() {
        if (this.selectedItem != null) {
            this.view.hide();
            if (this.onOk != null) {
                this.onOk.execute();
            }
        }
    }

    void onCancel() {
        this.view.hide();
        if (this.onCancel != null) {
            this.onCancel.execute();
        }
    }

    public static interface View
    extends UberView<PerspectiveDragConfigModal> {
        public void clearItems();

        public void addItem(String var1, Command var2);

        public void setCurrentSelection(String var1);

        public void setHelpText(String var1);

        public void show();

        public void hide();
    }
}

