/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.navigation.event.PerspectivePluginsChangedEvent;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.plugin.client.security.PluginController;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
public class PerspectivesExplorer
implements IsElement {
    View view;
    PerspectivePluginManager perspectivePluginManager;
    PlaceManager placeManager;
    PluginController pluginController;
    ContentManagerI18n i18n;

    @Inject
    public PerspectivesExplorer(View view, PerspectivePluginManager perspectivePluginManager, PluginController pluginController, PlaceManager placeManager, ContentManagerI18n i18n) {
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
        this.pluginController = pluginController;
        this.placeManager = placeManager;
        this.i18n = i18n;
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void show() {
        this.view.clear();
        this.perspectivePluginManager.getPerspectivePlugins(perspectivePlugins -> {
            List<Plugin> filteredPlugins = perspectivePlugins.stream().filter(arg_0 -> ((PluginController)this.pluginController).canRead(arg_0)).sorted((p1, p2) -> p1.getName().compareToIgnoreCase(p2.getName())).collect(Collectors.toList());
            if (filteredPlugins.isEmpty()) {
                this.view.showEmpty(this.i18n.getNoPerspectives());
            } else {
                filteredPlugins.forEach(p -> this.view.addPerspective(p.getName(), () -> this.onPerspectiveClick((Plugin)p)));
            }
        });
    }

    public void onPerspectiveClick(Plugin plugin) {
        PlaceRequest placeRequest = new PathPlaceRequest(plugin.getPath()).addParameter("name", plugin.getName());
        this.placeManager.goTo(placeRequest);
    }

    public void onPerspectivePluginsChanged(@Observes PerspectivePluginsChangedEvent event) {
        this.show();
    }

    public static interface View
    extends UberElement<PerspectivesExplorer> {
        public void clear();

        public void addPerspective(String var1, Command var2);

        public void showEmpty(String var1);
    }
}

