/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.client.cms.screen.transfer.DataTransferPopUp;
import org.dashbuilder.transfer.DataTransferServices;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;

@ApplicationScoped
@WorkbenchScreen(identifier="DataTransferScreen")
public class DataTransferScreen {
    public static final String ID = "DataTransferScreen";
    private View view;
    private Caller<DataTransferServices> dataTransferServices;
    private ContentManagerConstants i18n = ContentManagerConstants.INSTANCE;
    private DataTransferPopUp popUp;

    public DataTransferScreen() {
    }

    @Inject
    public DataTransferScreen(View view, DataTransferPopUp popUp, Caller<DataTransferServices> dataTransferServices) {
        this.view = view;
        this.popUp = popUp;
        this.dataTransferServices = dataTransferServices;
    }

    @WorkbenchPartTitle
    public String title() {
        return this.i18n.workbenchPartTitle();
    }

    @WorkbenchPartView
    public View part() {
        return this.view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void doExport() {
        try {
            ((DataTransferServices)this.dataTransferServices.call(path -> {
                this.view.exportOK();
                this.view.download((String)path);
            }, (message, throwable) -> {
                this.view.exportError(throwable);
                return false;
            })).doExport();
        }
        catch (Exception e) {
            this.view.exportError(e);
        }
    }

    public void doImport() {
        try {
            ((DataTransferServices)this.dataTransferServices.call(imported -> {
                this.view.importOK();
                this.popUp.show((List<String>)imported);
            }, (message, throwable) -> {
                this.view.importError(throwable);
                return false;
            })).doImport();
        }
        catch (Exception e) {
            this.view.importError(e);
        }
    }

    public String getFilePath() {
        return "dashbuilder-data-transfer";
    }

    public String getExportFileName() {
        return "export.zip";
    }

    public String getImportFileName() {
        return "import.zip";
    }

    public static interface View
    extends UberElemental<DataTransferScreen> {
        public void importOK();

        public void exportOK();

        public void importError(Throwable var1);

        public void exportError(Throwable var1);

        public void download(String var1);
    }
}

