/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.client.cms.screen.transfer.DataTransferPopUp;
import org.dashbuilder.client.cms.screen.transfer.export.wizard.ExportWizard;
import org.dashbuilder.transfer.DataTransferAssets;
import org.dashbuilder.transfer.DataTransferExportModel;
import org.dashbuilder.transfer.DataTransferServices;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
@WorkbenchScreen(identifier="DataTransferScreen")
public class DataTransferScreen {
    public static final String ID = "DataTransferScreen";
    private View view;
    private Caller<DataTransferServices> dataTransferServices;
    private ContentManagerConstants i18n = ContentManagerConstants.INSTANCE;
    private DataTransferPopUp popUp;
    private ExportWizard exportWizard;
    private BusyIndicatorView busyIndicatorView;
    protected ParameterizedCommand<DataTransferExportModel> gradualExportCallback;

    public DataTransferScreen() {
    }

    @Inject
    public DataTransferScreen(View view, DataTransferPopUp popUp, Caller<DataTransferServices> dataTransferServices, ExportWizard exportWizard, BusyIndicatorView busyIndicatorView) {
        this.view = view;
        this.popUp = popUp;
        this.dataTransferServices = dataTransferServices;
        this.exportWizard = exportWizard;
        this.busyIndicatorView = busyIndicatorView;
    }

    @WorkbenchPartTitle
    public String title() {
        return this.i18n.workbenchPartTitle();
    }

    @WorkbenchPartView
    public View part() {
        return this.view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.exportWizard.setCallback((ParameterizedCommand<DataTransferExportModel>)((ParameterizedCommand)this::callExportService));
    }

    public void doExport() {
        this.callExportService(DataTransferExportModel.exportAll());
    }

    public void doGradualExport() {
        this.busyIndicatorView.showBusyIndicator(this.i18n.loadingExportWizard());
        ((DataTransferServices)this.dataTransferServices.call(v -> {
            this.busyIndicatorView.hideBusyIndicator();
            this.exportWizard.start((DataTransferAssets)v);
        }, (message, error) -> {
            this.busyIndicatorView.hideBusyIndicator();
            this.view.exportError(error);
            return false;
        })).assetsToExport();
    }

    public void doImport() {
        try {
            ((DataTransferServices)this.dataTransferServices.call(imported -> {
                this.view.importOK();
                this.popUp.show((List<String>)imported);
            }, (message, throwable) -> {
                this.view.importError(throwable);
                return false;
            })).doImport();
        }
        catch (Exception e) {
            this.view.importError(e);
        }
    }

    public String getFilePath() {
        return "dashbuilder-data-transfer";
    }

    public String getExportFileName() {
        return "export.zip";
    }

    public String getImportFileName() {
        return "import.zip";
    }

    private void callExportService(DataTransferExportModel dataTransferExportModel) {
        this.busyIndicatorView.showBusyIndicator(this.i18n.preparingExportDownload());
        try {
            ((DataTransferServices)this.dataTransferServices.call(path -> {
                this.busyIndicatorView.hideBusyIndicator();
                this.view.exportOK();
                this.view.download((String)path);
            }, (message, throwable) -> {
                this.busyIndicatorView.hideBusyIndicator();
                this.view.exportError(throwable);
                return false;
            })).doExport(dataTransferExportModel);
        }
        catch (Exception e) {
            this.view.exportError(e);
        }
    }

    public static interface View
    extends UberElemental<DataTransferScreen> {
        public void importOK();

        public void exportOK();

        public void importError(Throwable var1);

        public void exportError(Throwable var1);

        public void download(String var1);
    }
}

