/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.client.cms.screen.transfer.DataTransferScreen;
import org.dashbuilder.client.cms.screen.transfer.export.wizard.widget.PagesTable;
import org.dashbuilder.common.client.backend.PathUrlFactory;
import org.dashbuilder.common.client.editor.file.FileUploadEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.spaces.SpacesAPI;
import org.uberfire.workbench.events.NotificationEvent;

@Templated
public class DataTransferView
implements DataTransferScreen.View,
IsElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTransferView.class);
    private DataTransferScreen presenter;
    private ContentManagerConstants i18n = ContentManagerConstants.INSTANCE;
    private HTMLDivElement root;
    private HTMLDivElement fileUploadContainer;
    private HTMLButtonElement btnImport;
    private FileUploadEditor fileUploadEditor;
    private Elemental2DomUtil elem2Dom;
    private Event<NotificationEvent> workbenchNotification;
    private PathUrlFactory pathUrlFactory;
    @Inject
    PagesTable pagesTable;

    public DataTransferView() {
    }

    @Inject
    public DataTransferView(@DataField HTMLDivElement root, @DataField HTMLDivElement fileUploadContainer, @DataField HTMLButtonElement btnImport, @DataField HTMLButtonElement btnExport, @DataField HTMLButtonElement btnGradualExport, FileUploadEditor fileUploadEditor, Elemental2DomUtil elem2Dom, Event<NotificationEvent> workbenchNotification, PathUrlFactory pathUrlFactory) {
        this.root = root;
        this.fileUploadContainer = fileUploadContainer;
        this.btnImport = btnImport;
        this.fileUploadEditor = fileUploadEditor;
        this.elem2Dom = elem2Dom;
        this.workbenchNotification = workbenchNotification;
        this.pathUrlFactory = pathUrlFactory;
    }

    public void init(final DataTransferScreen presenter) {
        this.presenter = presenter;
        this.btnImport.disabled = true;
        this.elem2Dom.appendWidgetToElement((HTMLElement)this.fileUploadContainer, this.fileUploadEditor.asWidget());
        this.fileUploadEditor.setAccept(".zip");
        this.fileUploadEditor.configure("fileUpload", new FileUploadEditor.FileUploadEditorCallback(){

            public String getUploadFileUrl() {
                String path = SpacesAPI.Scheme.DEFAULT + "://" + "system/system" + "/" + presenter.getFilePath() + "/" + presenter.getImportFileName();
                return DataTransferView.this.pathUrlFactory.getUploadFileUrl(path);
            }

            public String getUploadFileName() {
                return presenter.getImportFileName();
            }
        });
    }

    public HTMLElement getElement() {
        return this.root;
    }

    @Override
    public void download(String path) {
        DomGlobal.window.open((Object)this.pathUrlFactory.getDownloadFileUrl(path));
    }

    @Override
    public void exportError(Throwable throwable) {
        LOGGER.error(throwable.getMessage(), throwable);
        this.workbenchNotification.fire((Object)new NotificationEvent(this.i18n.exportError(), NotificationEvent.NotificationType.ERROR));
    }

    @Override
    public void importError(Throwable throwable) {
        this.btnImport.disabled = true;
        this.fileUploadEditor.view.clear();
        LOGGER.error(throwable.getMessage(), throwable);
        this.workbenchNotification.fire((Object)new NotificationEvent(this.i18n.importError(), NotificationEvent.NotificationType.ERROR));
    }

    @Override
    public void importOK() {
        this.btnImport.disabled = true;
        this.fileUploadEditor.view.clear();
        this.workbenchNotification.fire((Object)new NotificationEvent(this.i18n.importOK(), NotificationEvent.NotificationType.SUCCESS));
    }

    @Override
    public void exportOK() {
        this.workbenchNotification.fire((Object)new NotificationEvent(this.i18n.exportOK(), NotificationEvent.NotificationType.SUCCESS));
    }

    @EventHandler(value={"btnImport"})
    public void onImport(ClickEvent event) {
        this.presenter.doImport();
    }

    @EventHandler(value={"btnExport"})
    public void onExport(ClickEvent event) {
        this.presenter.doExport();
    }

    @EventHandler(value={"btnGradualExport"})
    public void onGradualExport(ClickEvent event) {
        this.presenter.doGradualExport();
    }

    void newFileUploaded(@Observes ValueChangeEvent<String> valueChangeEvent) {
        if (valueChangeEvent.getContext() == this.fileUploadEditor) {
            this.btnImport.disabled = false;
        }
    }
}

