/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer.export.wizard;

import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.HTMLElement;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.transfer.DataTransferAssets;
import org.dashbuilder.transfer.DataTransferExportModel;
import org.dashbuilder.transfer.ExportModelValidationService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
public class ExportSummaryWizardPage
implements WizardPage {
    ContentManagerConstants i18n = ContentManagerConstants.INSTANCE;
    @Inject
    View view;
    @Inject
    Caller<ExportModelValidationService> exportModelValidationService;
    @Inject
    private BusyIndicatorView busyIndicatorView;
    DataTransferAssets assets;
    private Supplier<DataTransferExportModel> exportModelSupplier;
    private ParameterizedCommand<DataTransferExportModel> dataTransferExportModelCallback;
    private DataTransferExportModel exportModel;
    private Command goToDataSetsCommand = () -> {};
    private Command goToPagesCommand = () -> {};

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public String getTitle() {
        return this.i18n.exportWizardTitle();
    }

    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)true);
    }

    public void initialise() {
        this.view.init(this);
    }

    public void prepareView() {
        this.validateAndUpdateView();
    }

    public void setGoToDataSetsCommand(Command goToDatasets) {
        this.goToDataSetsCommand = goToDatasets;
    }

    public void setGoToPagesCommand(Command goToPages) {
        this.goToPagesCommand = goToPages;
    }

    public void setExportSummary(Supplier<DataTransferExportModel> exportModelSupplier) {
        this.exportModelSupplier = exportModelSupplier;
    }

    public void setCallback(ParameterizedCommand<DataTransferExportModel> dataTransferExportModelCallback) {
        this.dataTransferExportModelCallback = dataTransferExportModelCallback;
    }

    void confirmDownload() {
        this.dataTransferExportModelCallback.execute((Object)this.exportModel);
    }

    public void goToDataSetsPage() {
        this.goToDataSetsCommand.execute();
    }

    public void goToPagesPage() {
        this.goToPagesCommand.execute();
    }

    private void validateAndUpdateView() {
        this.exportModel = this.exportModelSupplier.get();
        if (this.exportModel.getPages().isEmpty() && this.exportModel.getDatasetDefinitions().isEmpty()) {
            this.view.exportError(this.exportModel, this.i18n.nothingToExport());
            return;
        }
        if (this.exportModel.getPages().isEmpty()) {
            this.view.exportError(this.exportModel, this.i18n.noPagesExported());
            return;
        }
        this.view.emptyState();
        this.busyIndicatorView.showBusyIndicator(this.i18n.validatingExport());
        ((ExportModelValidationService)this.exportModelValidationService.call(validation -> {
            this.busyIndicatorView.hideBusyIndicator();
            if (validation.isEmpty()) {
                this.view.success(this.exportModel);
            } else {
                this.remapMissingDependencies((Map<String, List<String>>)validation);
                this.view.validationErrors(this.exportModel, (Map<String, List<String>>)validation);
            }
        }, (message, error) -> {
            this.busyIndicatorView.hideBusyIndicator();
            this.view.validationError(error);
            return false;
        })).checkMissingDatasets(this.exportModel);
    }

    void remapMissingDependencies(Map<String, List<String>> validation) {
        if (this.assets == null) {
            return;
        }
        List datasets = this.assets.getDatasetsDefinitions();
        validation.replaceAll((page, deps) -> deps.stream().map(uuid -> datasets.stream().filter(ds -> ds.getUUID().equals(uuid)).map(ds -> ds.getName()).findAny().orElse((String)uuid)).collect(Collectors.toList()));
    }

    public void setAssets(DataTransferAssets assets) {
        this.assets = assets;
    }

    public static interface View
    extends UberElemental<ExportSummaryWizardPage> {
        public void success(DataTransferExportModel var1);

        public void validationErrors(DataTransferExportModel var1, Map<String, List<String>> var2);

        public void exportError(DataTransferExportModel var1, String var2);

        public void emptyState();

        public void validationError(Throwable var1);
    }
}

