/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import com.google.gwt.user.client.Event;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.client.cms.widget.NewPerspectivePopUp;
import org.gwtbootstrap3.client.ui.Modal;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.ButtonPressed;

@Templated
@Dependent
public class NewPerspectivePopUpView
implements NewPerspectivePopUp.View,
IsElement {
    NewPerspectivePopUp presenter;
    BaseModal modal;
    ButtonPressed buttonPressed = ButtonPressed.CLOSE;
    ContentManagerConstants i18n = ContentManagerConstants.INSTANCE;
    @Inject
    @DataField
    Div body;
    @Inject
    @DataField
    Div footer;
    @Inject
    @DataField
    Div formDiv;
    @DataField
    @Inject
    Input nameInput;
    @DataField
    @Inject
    Span nameLabel;
    @DataField
    @Inject
    Span nameHelp;
    @Inject
    @DataField
    Span nameErrorLabel;
    @DataField
    @Inject
    Select styleSelect;
    @DataField
    @Inject
    Span styleLabel;
    @DataField
    @Inject
    Span styleHelp;
    @DataField
    @Inject
    Option fluidOption;
    @DataField
    @Inject
    Option pageOption;
    @DataField
    @Inject
    Button okButton;
    @DataField
    @Inject
    Button cancelButton;

    public void init(NewPerspectivePopUp presenter) {
        this.presenter = presenter;
        this.modal = new CommonModalBuilder().addHeader(this.i18n.newPerspectivePopUpViewTitle()).addBody((HTMLElement)this.body).addFooter((HTMLElement)this.footer).build();
        this.modal.addHiddenHandler(hiddenEvent -> {
            if (ButtonPressed.CLOSE.equals((Object)this.buttonPressed)) {
                presenter.onCancel();
            }
        });
    }

    public Modal getModal() {
        return this.modal;
    }

    @Override
    public void show() {
        this.nameInput.setValue("");
        this.nameErrorLabel.setTextContent("");
        this.formDiv.setClassName("form-group");
        this.fluidOption.setSelected(true);
        this.pageOption.setSelected(false);
        this.nameLabel.setTextContent(this.i18n.newPerspectivePopUpViewName());
        this.nameHelp.setTitle(this.i18n.newPerspectivePopUpViewNameHelp());
        this.styleLabel.setTextContent(this.i18n.newPerspectivePopUpViewStyle());
        this.styleHelp.setTitle(this.i18n.newPerspectivePopUpViewStyleHelp());
        this.okButton.setTextContent(this.i18n.newPerspectivePopUpViewOk());
        this.cancelButton.setTextContent(this.i18n.newPerspectivePopUpViewCancel());
        this.fluidOption.setTextContent(this.i18n.newPerspectivePopUpViewFluid());
        this.pageOption.setTextContent(this.i18n.newPerspectivePopUpViewPage());
        this.modal.setTitle(this.i18n.newPerspectivePopUpViewTitle());
        this.modal.show();
        this.nameInput.focus();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public String getName() {
        return this.nameInput.getValue();
    }

    @Override
    public String getStyle() {
        String val = this.styleSelect.getValue();
        return val;
    }

    @Override
    public void errorEmptyName() {
        this.showNameError(this.i18n.newPerspectivePopUpViewErrorEmptyName());
    }

    @Override
    public void errorInvalidName() {
        this.showNameError(this.i18n.newPerspectivePopUpViewErrorInvalidName());
    }

    @Override
    public void errorDuplicatedName() {
        this.showNameError(this.i18n.newPerspectivePopUpViewErrorDuplicatedName());
    }

    private void showNameError(String error) {
        this.formDiv.setClassName("form-group has-error");
        this.nameErrorLabel.setTextContent(error);
    }

    @SinkNative(value=1)
    @EventHandler(value={"okButton"})
    public void okClick(Event event) {
        this.buttonPressed = ButtonPressed.OK;
        this.presenter.onOK();
    }

    @SinkNative(value=1)
    @EventHandler(value={"cancelButton"})
    public void cancelClick(Event event) {
        this.buttonPressed = ButtonPressed.CANCEL;
        this.presenter.onCancel();
    }
}

