/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import org.dashbuilder.client.cms.widget.NewPerspectivePopUp;
import org.dashbuilder.client.cms.widget.NewPerspectivePopUpView;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.layout.editor.api.PerspectiveServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.plugin.client.validation.PluginNameValidator;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class NewPerspectivePopUpTest {
    @Mock
    private NewPerspectivePopUpView view;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private PerspectiveServices perspectiveServices;
    @Mock
    private PathPlaceRequest pathPlaceRequest;
    private PluginNameValidator pluginNameValidator;
    private NewPerspectivePopUp presenter;
    private boolean validationError = false;

    @Before
    public void setUp() {
        this.pluginNameValidator = (PluginNameValidator)Mockito.spy((Object)new PluginNameValidator(){

            public void validate(String value, ValidatorCallback callback) {
                if (NewPerspectivePopUpTest.this.validationError) {
                    callback.onFailure();
                } else {
                    callback.onSuccess();
                }
            }
        });
        this.presenter = new NewPerspectivePopUp(this.view, (Caller)new CallerMock((Object)this.perspectiveServices), this.pluginNameValidator, this.placeManager){

            protected PlaceRequest getPathPlaceRequest(Plugin response) {
                return NewPerspectivePopUpTest.this.pathPlaceRequest;
            }
        };
    }

    @Test
    public void testSuccessfulValidation() {
        this.validationError = false;
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"newPerspective");
        Mockito.when((Object)this.view.getStyle()).thenReturn((Object)LayoutTemplate.Style.FLUID.toString());
        this.presenter.onOK();
        ((PluginNameValidator)Mockito.verify((Object)this.pluginNameValidator)).validate((String)Matchers.eq((Object)"newPerspective.plugin"), (ValidatorCallback)Matchers.any(ValidatorCallback.class));
        ((PerspectiveServices)Mockito.verify((Object)this.perspectiveServices)).createNewPerspective("newPerspective", LayoutTemplate.Style.FLUID);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)this.pathPlaceRequest);
        ((NewPerspectivePopUpView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testFailedValidation() {
        this.validationError = true;
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"invalid*");
        Mockito.when((Object)this.view.getStyle()).thenReturn((Object)LayoutTemplate.Style.FLUID.toString());
        this.presenter.onOK();
        ((PluginNameValidator)Mockito.verify((Object)this.pluginNameValidator)).validate((String)Matchers.eq((Object)"invalid*.plugin"), (ValidatorCallback)Matchers.any(ValidatorCallback.class));
        ((PerspectiveServices)Mockito.verify((Object)this.perspectiveServices, (VerificationMode)Mockito.never())).createNewPerspective(Mockito.anyString(), (LayoutTemplate.Style)Matchers.any());
        ((NewPerspectivePopUpView)Mockito.verify((Object)this.view)).errorInvalidName();
        ((NewPerspectivePopUpView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void testPopupCanceled() {
        this.presenter.onCancel();
        ((PluginNameValidator)Mockito.verify((Object)this.pluginNameValidator, (VerificationMode)Mockito.never())).validate(Mockito.anyString(), (ValidatorCallback)Matchers.any(ValidatorCallback.class));
        ((PerspectiveServices)Mockito.verify((Object)this.perspectiveServices, (VerificationMode)Mockito.never())).createNewPerspective(Mockito.anyString(), (LayoutTemplate.Style)Matchers.any());
        ((NewPerspectivePopUpView)Mockito.verify((Object)this.view)).hide();
    }
}

