/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.layout.editor;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.dashbuilder.client.cms.layout.editor.PerspectiveDragConfigModal;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.gwtbootstrap3.client.ui.Modal;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Label;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.TemplateWidgetMapper;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.ButtonPressed;

@Templated
public class PerspectiveDragConfigModalView
implements PerspectiveDragConfigModal.View {
    PerspectiveDragConfigModal presenter;
    BaseModal modal;
    ButtonPressed buttonPressed = ButtonPressed.CLOSE;
    @Inject
    @DataField
    Div body;
    @Inject
    @DataField
    Div footer;
    @DataField
    @Inject
    Span selectorHelp;
    @DataField
    @Inject
    Span currentSelection;
    @DataField
    @Inject
    UnorderedList selectorItems;
    @DataField
    @Inject
    Label navItemLabel;

    public void init(PerspectiveDragConfigModal presenter) {
        this.presenter = presenter;
        this.currentSelection.setTextContent(ContentManagerConstants.INSTANCE.perspectiveDragSelectorHint());
        this.navItemLabel.setTextContent(ContentManagerConstants.INSTANCE.perspectiveDragSelectorLabel());
        this.modal = new CommonModalBuilder().addHeader(ContentManagerConstants.INSTANCE.perspectiveDragComponentHeader()).addBody((HTMLElement)this.body).addFooter((HTMLElement)this.footer).build();
        this.modal.addHiddenHandler(hiddenEvent -> {
            if (ButtonPressed.CLOSE.equals((Object)this.buttonPressed)) {
                presenter.onCancel();
            }
        });
        this.modal.setWidth("960px");
    }

    public Modal getModal() {
        return this.modal;
    }

    public Widget asWidget() {
        return TemplateWidgetMapper.get((Object)this.modal);
    }

    @Override
    public void show() {
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void clearItems() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.selectorItems);
    }

    @Override
    public void setHelpText(String text) {
        this.selectorHelp.setTitle(text);
    }

    @Override
    public void setCurrentSelection(String name) {
        this.currentSelection.setTextContent(name);
    }

    @Override
    public void addItem(String name, Command onSelect) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.setInnerText(name);
        LIElement li = Document.get().createLIElement();
        li.getStyle().setCursor(Style.Cursor.POINTER);
        li.appendChild((Node)anchor);
        this.selectorItems.appendChild((org.jboss.errai.common.client.dom.Node)li);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                onSelect.execute();
            }
        });
    }

    @SinkNative(value=1)
    @EventHandler(value={"okButton"})
    public void okClick(Event event) {
        this.buttonPressed = ButtonPressed.OK;
        this.presenter.onOk();
    }

    @SinkNative(value=1)
    @EventHandler(value={"cancelButton"})
    public void cancelClick(Event event) {
        this.buttonPressed = ButtonPressed.CANCEL;
        this.presenter.onCancel();
    }
}

