/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer.export.wizard.widget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLCollection;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLTableCellElement;
import elemental2.dom.HTMLTableElement;
import elemental2.dom.HTMLTableRowElement;
import elemental2.dom.HTMLTableSectionElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.cms.screen.util.DomFactory;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.mvp.UberElemental;

@Dependent
@Templated
public class AssetsTableView
implements UberElemental<Presenter> {
    @Inject
    DomFactory domFactory;
    @Inject
    @DataField
    HTMLDivElement assetTableWidgetRoot;
    @Inject
    @DataField
    HTMLInputElement searchAssets;
    @Inject
    @DataField
    HTMLTableElement assetsTable;
    @Inject
    @DataField
    HTMLInputElement selectAllAssets;
    @Inject
    @DataField
    HTMLTableRowElement assetsTableHeaderRow;
    Presenter presenter;

    public void init(Presenter presenter) {
        this.presenter = presenter;
        this.buildHeaders(presenter.getHeaders());
    }

    public void update() {
        ((HTMLTableSectionElement)this.assetsTable.tBodies.getAt((int)0)).innerHTML = "";
        this.selectAllAssets.checked = true;
        Arrays.stream(this.presenter.rows()).map(this::toRow).forEach(this::appendRow);
    }

    public List<?> getSelectedAssets() {
        List data = this.presenter.getData();
        HTMLCollection rows = ((HTMLTableSectionElement)this.assetsTable.tBodies.getAt((int)0)).rows;
        return IntStream.range(0, rows.getLength()).filter(i -> {
            Element checkBox = ((HTMLTableRowElement)rows.getAt(i)).querySelector("td > input[type=checkbox]");
            return ((HTMLInputElement)checkBox).checked;
        }).mapToObj(data::get).collect(Collectors.toList());
    }

    public HTMLElement getElement() {
        return this.assetTableWidgetRoot;
    }

    @EventHandler(value={"selectAllAssets"})
    void selectAll(ClickEvent event) {
        this.allInputsForTable().forEach(chk -> {
            chk.checked = this.selectAllAssets.checked;
        });
    }

    @EventHandler(value={"searchAssets"})
    void onFilter(KeyUpEvent keyDown) {
        this.filterTable();
    }

    public void clearFilter() {
        this.searchAssets.value = "";
        this.filterTable();
    }

    void appendRow(HTMLTableRowElement row) {
        ((HTMLTableSectionElement)this.assetsTable.tBodies.getAt(0)).appendChild((Node)row);
    }

    HTMLTableRowElement toRow(String[] cells) {
        HTMLTableRowElement row = this.domFactory.tableRow();
        row.appendChild((Node)this.createRowSelectorCell());
        Arrays.stream(cells).map(this::createCell).forEach(arg_0 -> ((HTMLTableRowElement)row).appendChild(arg_0));
        return row;
    }

    void filterTable() {
        String query = this.searchAssets.value.trim().toLowerCase();
        HTMLCollection rows = ((HTMLTableSectionElement)this.assetsTable.tBodies.getAt((int)0)).rows;
        IntStream.range(0, rows.getLength()).mapToObj(arg_0 -> ((HTMLCollection)rows).getAt(arg_0)).forEach(row -> {
            row.hidden = false;
            if (!query.isEmpty()) {
                row.hidden = IntStream.range(0, row.cells.getLength()).mapToObj(arg_0 -> ((HTMLCollection)row.cells).getAt(arg_0)).noneMatch(c -> c.textContent.toLowerCase().contains(query));
            }
        });
    }

    private HTMLInputElement createCheckBox() {
        HTMLInputElement checkbox = this.domFactory.input();
        checkbox.type = "checkbox";
        checkbox.checked = true;
        return checkbox;
    }

    private HTMLTableCellElement createCell(String content) {
        HTMLTableCellElement cell = this.domFactory.tableCell();
        cell.innerHTML = content;
        return cell;
    }

    private Element createHeaderCell(String content) {
        Element cell = this.domFactory.element("th");
        cell.innerHTML = content;
        return cell;
    }

    private HTMLTableCellElement createRowSelectorCell() {
        HTMLTableCellElement tableCell = this.domFactory.tableCell();
        HTMLInputElement rowChk = this.createCheckBox();
        rowChk.onclick = e -> {
            this.selectAllAssets.checked = this.allInputsForTable().allMatch(input -> rowChk.checked);
            return null;
        };
        tableCell.appendChild((Node)rowChk);
        return tableCell;
    }

    private Stream<HTMLInputElement> allInputsForTable() {
        NodeList items = this.assetsTable.querySelectorAll("tbody > tr > td:first-of-type > input[type=checkbox]");
        return IntStream.range(0, items.getLength()).mapToObj(i -> (HTMLInputElement)items.getAt(i));
    }

    private void buildHeaders(String[] headers) {
        Arrays.stream(headers).map(this::createHeaderCell).forEach(arg_0 -> ((HTMLTableRowElement)this.assetsTableHeaderRow).appendChild(arg_0));
    }

    public static interface Presenter<T> {
        public List<T> getData();

        public List<T> getSelectedData();

        public String[] getHeaders();

        public String[] toRow(T var1);

        public void setData(List<T> var1);

        default public String[][] rows() {
            List<T> data = this.getData();
            String[][] rows = new String[data.size()][];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = this.toRow(data.get(i));
            }
            return rows;
        }
    }
}

