/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.perspective;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.cms.perspective.ContentManagerPerspective;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.ext.layout.editor.client.api.LayoutEditor;
import org.uberfire.ext.layout.editor.client.widgets.LayoutEditorPropertiesPresenter;
import org.uberfire.ext.plugin.client.perspective.editor.events.PerspectiveEditorFocusEvent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class ContentManagerPerspectiveTest {
    @Mock
    ContentManagerI18n i18n;
    @Mock
    UberfireDocks uberfireDocks;
    @Mock
    PerspectiveChange perspectiveChangeEvent;
    @Mock
    LayoutEditorPropertiesPresenter propertiesPresenter;
    @Mock
    LayoutEditor layoutEditor;
    @InjectMocks
    ContentManagerPerspective perspective;

    @Before
    public void setUp() {
        Mockito.when((Object)this.perspectiveChangeEvent.getIdentifier()).thenReturn((Object)"anotherPerspective");
        this.perspective.init();
        this.perspective.onOpen();
    }

    @Test
    public void testInit() {
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).add(new UberfireDock[]{this.perspective.perspectivesExplorerDock});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).add(new UberfireDock[]{this.perspective.navigationExplorerDock});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).remove(new UberfireDock[]{this.perspective.componentPaletteDock});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).open(this.perspective.perspectivesExplorerDock);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).show(UberfireDockPosition.WEST, "ContentManagerPerspective");
    }

    @Test
    public void testOnLayoutEditorFocus() {
        Mockito.reset((Object[])new UberfireDocks[]{this.uberfireDocks});
        this.perspective.onPerspectiveEditorFocus(new PerspectiveEditorFocusEvent(this.layoutEditor));
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).add(new UberfireDock[]{this.perspective.componentPaletteDock});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).open(this.perspective.componentPaletteDock);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).show(UberfireDockPosition.WEST, "ContentManagerPerspective");
    }

    @Test
    public void testOnLayoutEditorHidden() {
        this.perspective.onPerspectiveEditorFocus(new PerspectiveEditorFocusEvent(this.layoutEditor));
        Mockito.reset((Object[])new UberfireDocks[]{this.uberfireDocks});
        this.perspective.onPerspectiveEditorHidden(new PlaceHiddenEvent((PlaceRequest)new DefaultPlaceRequest("Perspective Editor")));
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).remove(new UberfireDock[]{this.perspective.componentPaletteDock});
    }
}

