/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.dashbuilder.client.cms.widget.PerspectivesExplorer;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.plugin.client.security.PluginController;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class PerspectivesExplorerTest {
    @Mock
    PerspectivesExplorer.View viewM;
    @Mock
    PerspectivePluginManager perspectivePluginManagerM;
    @Mock
    PlaceManager placeManagerM;
    @Mock
    PluginController pluginControllerM;
    @Mock
    ContentManagerI18n i18nM;
    PerspectivesExplorer perspectivesExplorer;
    Plugin a = this.mkPlugin("a");
    Plugin b = this.mkPlugin("B");
    Plugin c = this.mkPlugin("cEE");
    List<Plugin> pluginList = Arrays.asList(this.b, this.c, this.a);

    private Plugin mkPlugin(String name) {
        return new Plugin(name, PluginType.PERSPECTIVE, null);
    }

    @Before
    public void setUp() {
        ((PerspectivePluginManager)Mockito.doAnswer(invocationOnMock -> {
            ParameterizedCommand callback = (ParameterizedCommand)invocationOnMock.getArgument(0, ParameterizedCommand.class);
            callback.execute(this.pluginList);
            return null;
        }).when((Object)this.perspectivePluginManagerM)).getPerspectivePlugins((ParameterizedCommand)ArgumentMatchers.any());
        this.perspectivesExplorer = new PerspectivesExplorer(this.viewM, this.perspectivePluginManagerM, this.pluginControllerM, this.placeManagerM, this.i18nM);
    }

    @Test
    public void testPerspectiveListEmpty() {
        this.pluginList = new ArrayList<Plugin>();
        this.perspectivesExplorer.show();
        ((PerspectivesExplorer.View)Mockito.verify((Object)this.viewM)).clear();
        ((PerspectivesExplorer.View)Mockito.verify((Object)this.viewM)).showEmpty((String)ArgumentMatchers.any());
    }

    @Test
    public void testPerspectivesAvailable() {
        Mockito.when((Object)this.pluginControllerM.canRead((Activity)ArgumentMatchers.any())).thenReturn((Object)true);
        this.perspectivesExplorer.show();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.viewM});
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).clear();
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).addPerspective((String)ArgumentMatchers.eq((Object)"a"), (Command)ArgumentMatchers.any());
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).addPerspective((String)ArgumentMatchers.eq((Object)"B"), (Command)ArgumentMatchers.any());
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).addPerspective((String)ArgumentMatchers.eq((Object)"cEE"), (Command)ArgumentMatchers.any());
    }

    @Test
    public void testPerspectiveReadAccessDenied() {
        Mockito.when((Object)this.pluginControllerM.canRead((Activity)this.a)).thenReturn((Object)true);
        Mockito.when((Object)this.pluginControllerM.canRead((Activity)this.b)).thenReturn((Object)true);
        this.perspectivesExplorer.show();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.viewM});
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).clear();
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).addPerspective((String)ArgumentMatchers.eq((Object)"a"), (Command)ArgumentMatchers.any());
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM)).addPerspective((String)ArgumentMatchers.eq((Object)"B"), (Command)ArgumentMatchers.any());
        ((PerspectivesExplorer.View)inOrder.verify((Object)this.viewM, Mockito.never())).addPerspective((String)ArgumentMatchers.eq((Object)"cEE"), (Command)ArgumentMatchers.any());
    }
}

