/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.validation.editors;

import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.Tooltip;
import com.github.gwtbootstrap.client.ui.constants.LabelType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class BooleanSwitchEditor
extends Composite
implements HasValue<Boolean>,
HasEditorErrors<Boolean>,
IsEditor<TakesValueEditor<Boolean>> {
    public static final String ON = "ON";
    public static final String OFF = "OFF";
    @UiField
    BooleanSwitchEditorStyle style;
    @UiField
    HTMLPanel mainPanel;
    @UiField
    Tooltip errorTooltip;
    @UiField
    @Editor.Ignore
    Label label;
    private boolean isEditMode = true;
    private TakesValueEditor<Boolean> editor = TakesValueEditor.of((TakesValue)this);
    private Boolean value;

    @UiConstructor
    public BooleanSwitchEditor() {
        this.initWidget((Widget)Binder.BINDER.createAndBindUi((Object)this));
        if (this.isEditMode) {
            this.label.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    BooleanSwitchEditor.this.labelSwitchValue();
                }
            });
        }
    }

    public void setEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
    }

    public TakesValueEditor<Boolean> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of((TakesValue)this);
        }
        return this.editor;
    }

    public Boolean getValue() {
        return this.value;
    }

    public void setValue(Boolean value) {
        this.setValue(value, false);
    }

    public void setValue(Boolean value, boolean fireEvents) {
        if (value == this.value || this.value != null && this.value.equals(value)) {
            return;
        }
        this.disableError();
        Boolean before = this.value;
        this.value = value;
        if (this.value.booleanValue()) {
            this.labelON();
        } else {
            this.labelOFF();
        }
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, (Object)before, (Object)value);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors = errors != null && !errors.isEmpty();
        String toolTipText = null;
        if (hasErrors) {
            StringBuilder sb = new StringBuilder();
            for (EditorError error : errors) {
                sb.append("\n").append(error.getMessage());
            }
            if (sb.length() > 0) {
                toolTipText = sb.substring(1);
            }
        }
        if (toolTipText != null) {
            this.enableError(toolTipText);
        } else {
            this.disableError();
        }
    }

    private void enableError(String text) {
        this.setTooltipText(text);
        this.markErrorPanel(true);
    }

    private void disableError() {
        this.setTooltipText(null);
        this.markErrorPanel(false);
    }

    private void markErrorPanel(boolean error) {
        if (error) {
            this.mainPanel.addStyleName(this.style.mainPanelError());
        } else {
            this.mainPanel.removeStyleName(this.style.mainPanelError());
        }
    }

    private void labelSwitchValue() {
        if (this.isLabelON()) {
            this.setValue(false, true);
        } else {
            this.setValue(true, true);
        }
    }

    private void labelON() {
        this.label.setText(ON);
        this.label.setType(LabelType.SUCCESS);
    }

    private void labelOFF() {
        this.label.setText(OFF);
        this.label.setType(LabelType.DEFAULT);
    }

    private boolean isLabelON() {
        return ON.equals(this.label.getText());
    }

    private void setTooltipText(String text) {
        if (text == null || text.trim().length() == 0) {
            this.errorTooltip.setText("");
        } else {
            this.errorTooltip.setText(text);
        }
        this.errorTooltip.reconfigure();
    }

    public void clear() {
        this.setValue(false);
        this.disableError();
    }

    static interface BooleanSwitchEditorStyle
    extends CssResource {
        public String mainPanel();

        public String mainPanelError();

        public String label();
    }

    static interface Binder
    extends UiBinder<Widget, BooleanSwitchEditor> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

