/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets.slider.presenter;

public class SliderBarCalculator {
    protected int maxValue;
    protected int absMaxLength;
    protected int minPosition;
    protected int maxPosition;
    private int step;
    private double k;

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setAbsMaxLength(int absMaxLength) {
        this.absMaxLength = absMaxLength;
    }

    protected void processParams() {
        int usedAbsLength = this.absMaxLength;
        this.minPosition = 0;
        this.maxPosition = this.absMaxLength;
        if (this.absMaxLength >= this.maxValue) {
            usedAbsLength = this.absMaxLength - this.absMaxLength % this.maxValue;
            this.minPosition = (this.absMaxLength - usedAbsLength) / 2;
            this.maxPosition = this.minPosition + usedAbsLength;
        }
        this.step = usedAbsLength / this.maxValue;
        if (this.step == 0) {
            this.step = 1;
        }
        this.k = (double)usedAbsLength / (double)this.maxValue;
    }

    public int checkAbsPosition(int absPosition) {
        if (absPosition < this.minPosition) {
            absPosition = this.minPosition;
        }
        if (absPosition > this.maxPosition) {
            absPosition = this.maxPosition;
        }
        return absPosition;
    }

    protected int clcValueByAbsPosition(int currentAbsPosition) {
        currentAbsPosition = this.checkAbsPosition(currentAbsPosition) - this.minPosition;
        int value = (int)Math.round((double)currentAbsPosition / this.k);
        return value;
    }

    protected int clcAbsPositionByValue(int value) {
        int absPosition = this.k >= 1.0 ? value * this.step : (int)Math.round((double)value * this.k);
        return absPosition + this.minPosition;
    }
}

