/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.error;

import org.dashbuilder.common.client.StringUtils;

public class ClientRuntimeError {
    private String message;
    private Throwable throwable;

    public ClientRuntimeError(String message) {
        this(message, null);
    }

    public ClientRuntimeError(Throwable e) {
        this(null, e);
    }

    public ClientRuntimeError(String message, Throwable e) {
        this.message = message;
        this.throwable = e;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getMessage() {
        if (!StringUtils.isBlank(this.message)) {
            return this.message;
        }
        Throwable root = this._getRootCause();
        return root.toString();
    }

    public String getCause() {
        Throwable root = this._getRootCause();
        if (root == null || this.getMessage().equals(root.toString())) {
            return null;
        }
        return root.getMessage();
    }

    public Throwable _getRootCause() {
        Throwable target = this.throwable;
        while (target != null && target.getCause() != null) {
            target = target.getCause();
        }
        return target;
    }

    public String toString() {
        String cause = this.getCause();
        return this.getMessage() + (cause != null ? " (cause: " + cause + ")" : "");
    }
}

