/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.validation.editors;

import com.github.gwtbootstrap.client.ui.DropdownButton;
import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.Tooltip;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasConstrainedValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DropDownImageListEditor<T>
extends Composite
implements HasConstrainedValue<T>,
HasEditorErrors<T>,
IsEditor<TakesValueEditor<T>> {
    private final List<T> values = new ArrayList<T>();
    private TakesValueEditor<T> editor;
    private final Map<T, Image> images = new LinkedHashMap<T, Image>();
    private T value;
    private boolean isEditMode;
    private int width = -1;
    private int height = -1;
    protected boolean fireEvents = false;
    @UiField
    DropDownImageListEditorStyle style;
    @UiField
    HTMLPanel errorPanel;
    @UiField
    Image currentTypeImage;
    @UiField(provided=true)
    DropdownButton dropDownButton = new DropdownButton(){

        protected IconAnchor createTrigger() {
            DropDownImageListEditor.this.trigger = super.createTrigger();
            return DropDownImageListEditor.this.trigger;
        }
    };
    @UiField
    Tooltip errorTooltip;
    private IconAnchor trigger;

    @UiConstructor
    public DropDownImageListEditor() {
        this.dropDownButton.setType(ButtonType.LINK);
        this.initWidget((Widget)Binder.BINDER.createAndBindUi((Object)this));
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public TakesValueEditor<T> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of((TakesValue)this);
        }
        return this.editor;
    }

    public T getValue() {
        return this.value;
    }

    public void setAcceptableValues(Map<T, Image> newValues) {
        this.values.clear();
        this.images.clear();
        if (newValues != null && !newValues.isEmpty()) {
            for (Map.Entry<T, Image> entry : newValues.entrySet()) {
                final T _value = entry.getKey();
                Image _image = entry.getValue();
                if (this.width > 0 && this.height > 0) {
                    _image.setSize(this.width + "px", this.height + "px");
                }
                _image.addStyleName(this.style.imagePointer());
                _image.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (DropDownImageListEditor.this.isEditMode) {
                            DropDownImageListEditor.this.setValue(_value, DropDownImageListEditor.this.fireEvents);
                        }
                    }
                });
                this.values.add(_value);
                this.images.put(_value, _image);
            }
        }
        if (this.values.size() == 1) {
            this.trigger.setActive(false);
            this.trigger.setCaret(false);
        }
    }

    private void buildUIDropDown() {
        this.dropDownButton.clear();
        this.dropDownButton.addCustomTrigger((Widget)this.currentTypeImage);
        this.dropDownButton.getMenuWiget().setVisible(false);
        if (this.images != null && this.images.size() > 1) {
            this.dropDownButton.getMenuWiget().setVisible(true);
            for (Map.Entry<T, Image> entry : this.images.entrySet()) {
                if (this.value == null || this.value.equals(entry.getKey())) continue;
                this.dropDownButton.add((Widget)entry.getValue());
            }
        }
    }

    public void setAcceptableValues(Collection<T> newValues) {
        this.values.clear();
        if (newValues != null) {
            for (T nextNewValue : newValues) {
                this.values.add(nextNewValue);
            }
        }
    }

    public void setValue(T value) {
        this.setValue(value, false);
    }

    public void setValue(T value, boolean fireEvents) {
        this.disableError();
        if (value == this.value || this.value != null && this.value.equals(value)) {
            return;
        }
        T before = this.value;
        this.value = value;
        for (T entry : this.values) {
            Image image = this.images.get(entry);
            if (!entry.equals(value)) continue;
            this.currentTypeImage.setUrl(image.getUrl());
            this.currentTypeImage.setSize("16px", "16px");
            this.currentTypeImage.setAltText(image.getAltText());
        }
        this.buildUIDropDown();
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, before, value);
        }
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors = errors != null && !errors.isEmpty();
        String toolTipText = null;
        if (hasErrors) {
            StringBuilder sb = new StringBuilder();
            for (EditorError error : errors) {
                sb.append("\n").append(error.getMessage());
            }
            if (sb.length() > 0) {
                toolTipText = sb.substring(1);
            }
        }
        if (toolTipText != null) {
            this.enableError(toolTipText);
        } else {
            this.disableError();
        }
    }

    private void enableError(String text) {
        this.setTooltipText(text);
        this.markErrorPanel(true);
    }

    private void disableError() {
        this.setTooltipText(null);
        this.markErrorPanel(false);
    }

    public void setEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void clear() {
        this.setValue(null);
    }

    private void markErrorPanel(boolean error) {
        if (error) {
            this.errorPanel.addStyleName(this.style.errorPanelError());
        } else {
            this.errorPanel.removeStyleName(this.style.errorPanelError());
        }
    }

    private void setTooltipText(String text) {
        if (text == null || text.trim().length() == 0) {
            this.errorTooltip.setText("");
        } else {
            this.errorTooltip.setText(text);
        }
        this.errorTooltip.reconfigure();
    }

    static interface DropDownImageListEditorStyle
    extends CssResource {
        public String errorPanel();

        public String errorPanelError();

        public String imagePointer();
    }

    static interface Binder
    extends UiBinder<Widget, DropDownImageListEditor> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

