/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.validation.editors;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ButtonCell;
import com.github.gwtbootstrap.client.ui.DataGrid;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dashbuilder.common.client.resources.i18n.DashbuilderCommonConstants;

public class MapEditor<T, K>
extends Composite
implements HasValue<Map<T, K>>,
HasEditorErrors<Map<T, K>>,
IsEditor<TakesValueEditor<Map<T, K>>> {
    private Map<T, K> value;
    private TakesValueEditor<Map<T, K>> editor;
    @UiField
    MapEditorStyle style;
    @UiField
    HTMLPanel mainPanel;
    @UiField
    ScrollPanel gridPanel;
    @UiField
    DataGrid<Map.Entry<T, K>> grid;
    @UiField
    @Editor.Ignore
    Button addButton;
    @UiField
    @Editor.Ignore
    Label errorLabel;
    private final ListDataProvider<Map.Entry<T, K>> model = new ListDataProvider(new LinkedList());
    private final ClickHandler addClickHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            MapEditor.this.fireEvent(new ValueAddEvent(DashbuilderCommonConstants.INSTANCE.newValue(), DashbuilderCommonConstants.INSTANCE.newValue()));
        }
    };
    private final FieldUpdater removeButtonHandler = new FieldUpdater<Map.Entry<T, K>, String>(){

        public void update(int index, Map.Entry<T, K> object, String value) {
            MapEditor.this.removeEntry(object.getKey());
            MapEditor.this.redraw();
        }
    };
    private final FieldUpdater keyModifiedEventHandler = new FieldUpdater<Map.Entry<T, K>, String>(){

        public void update(int index, Map.Entry<T, K> object, String value) {
            MapEditor.this.fireEvent(new KeyModifiedEvent(index, object.getKey().toString(), value));
        }
    };
    private final FieldUpdater valueModifiedEventHandler = new FieldUpdater<Map.Entry<T, K>, String>(){

        public void update(int index, Map.Entry<T, K> object, String value) {
            MapEditor.this.fireEvent(new ValueModifiedEvent(index, object.getValue().toString(), value));
        }
    };

    public MapEditor() {
        this.initWidget((Widget)Binder.BINDER.createAndBindUi((Object)this));
        this.createGrid();
        this.addButton.addClickHandler(this.addClickHandler);
    }

    public void showErrors(List<EditorError> errors) {
    }

    public Map<T, K> getValue() {
        return this.value;
    }

    public void setValue(Map<T, K> value) {
        this.setValue(value, false);
    }

    public void setValue(Map<T, K> value, boolean fireEvents) {
        this.disableError();
        Map<T, K> before = this.value;
        this.value = value;
        this.redraw();
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, before, value);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Map<T, K>> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public TakesValueEditor<Map<T, K>> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of((TakesValue)this);
        }
        return this.editor;
    }

    private void createGrid() {
        this.grid.setEmptyTableWidget((Widget)new com.google.gwt.user.client.ui.Label(DashbuilderCommonConstants.INSTANCE.noData()));
        Column keyColumn = new Column<Map.Entry<T, K>, String>((Cell)new EditTextCell()){

            public String getValue(Map.Entry<T, K> object) {
                return object.getKey().toString();
            }
        };
        keyColumn.setSortable(false);
        keyColumn.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.grid.addColumn(keyColumn, DashbuilderCommonConstants.INSTANCE.key());
        this.grid.setColumnWidth(keyColumn, 20.0, Style.Unit.PCT);
        keyColumn.setFieldUpdater(this.keyModifiedEventHandler);
        Column valueColumn = new Column<Map.Entry<T, K>, String>((Cell)new EditTextCell()){

            public String getValue(Map.Entry<T, K> object) {
                return object.getValue().toString();
            }
        };
        valueColumn.setSortable(false);
        valueColumn.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.grid.addColumn(valueColumn, DashbuilderCommonConstants.INSTANCE.value());
        this.grid.setColumnWidth(valueColumn, 20.0, Style.Unit.PCT);
        valueColumn.setFieldUpdater(this.valueModifiedEventHandler);
        Column removeColumn = new Column<Map.Entry<T, K>, String>((Cell)new ButtonCell(IconType.MINUS, ButtonSize.MINI)){

            public String getValue(Map.Entry<T, K> object) {
                return null;
            }
        };
        removeColumn.setFieldUpdater(this.removeButtonHandler);
        removeColumn.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.grid.addColumn(removeColumn, DashbuilderCommonConstants.INSTANCE.actions());
        this.grid.setColumnWidth(removeColumn, 20.0, Style.Unit.PCT);
    }

    private K removeEntry(T key) {
        return this.value.remove(key);
    }

    public void redraw() {
        this.grid.removeColumn(0);
        this.grid.removeColumn(0);
        this.grid.removeColumn(0);
        this.createGrid();
        int count = this.value != null ? this.value.size() : 0;
        LinkedList<Map.Entry<T, K>> list = this.value != null ? new LinkedList<Map.Entry<T, K>>(this.value.entrySet()) : new LinkedList();
        this.grid.setRowCount(count);
        this.grid.setRowData(0, list);
    }

    private void enableError(String text) {
        this.setLabelText(text);
        this.errorLabel.setVisible(true);
    }

    private void disableError() {
        this.setLabelText(null);
        this.errorLabel.setVisible(false);
    }

    public void clear() {
        this.setValue(null);
        this.disableError();
    }

    private void setLabelText(String text) {
        if (text == null || text.trim().length() == 0) {
            this.errorLabel.setText("");
        } else {
            this.errorLabel.setText(text);
        }
    }

    public HandlerRegistration addValueAddEventHandler(ValueAddEventHandler handler) {
        return this.addHandler(handler, ValueAddEvent.TYPE);
    }

    public HandlerRegistration addValueModifiedEventHandler(ValueModifiedEventHandler handler) {
        return this.addHandler(handler, ValueModifiedEvent.TYPE);
    }

    public HandlerRegistration addKeyModifiedEventHandler(KeyModifiedEventHandler handler) {
        return this.addHandler(handler, KeyModifiedEvent.TYPE);
    }

    public static interface ValueModifiedEventHandler
    extends EventHandler {
        public void onValueModified(ValueModifiedEvent var1);
    }

    public static interface KeyModifiedEventHandler
    extends EventHandler {
        public void onKeyModified(KeyModifiedEvent var1);
    }

    public static class KeyModifiedEvent
    extends AbstractValueModifiedEvent<KeyModifiedEventHandler> {
        public static GwtEvent.Type<KeyModifiedEventHandler> TYPE = new GwtEvent.Type();

        public KeyModifiedEvent(int index, String last, String value) {
            super(index, last, value);
        }

        public GwtEvent.Type<KeyModifiedEventHandler> getAssociatedType() {
            return TYPE;
        }

        protected void dispatch(KeyModifiedEventHandler handler) {
            handler.onKeyModified(this);
        }
    }

    public static class ValueModifiedEvent
    extends AbstractValueModifiedEvent<ValueModifiedEventHandler> {
        public static GwtEvent.Type<ValueModifiedEventHandler> TYPE = new GwtEvent.Type();

        public ValueModifiedEvent(int index, String last, String value) {
            super(index, last, value);
        }

        public GwtEvent.Type<ValueModifiedEventHandler> getAssociatedType() {
            return TYPE;
        }

        protected void dispatch(ValueModifiedEventHandler handler) {
            handler.onValueModified(this);
        }
    }

    public static abstract class AbstractValueModifiedEvent<T extends EventHandler>
    extends GwtEvent<T> {
        private int index;
        private String last;
        private String value;

        public AbstractValueModifiedEvent(int index, String last, String value) {
            this.index = index;
            this.last = last;
            this.value = value;
        }

        public int getIndex() {
            return this.index;
        }

        public String getLast() {
            return this.last;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface ValueAddEventHandler
    extends EventHandler {
        public void onValueAdd(ValueAddEvent var1);
    }

    public static class ValueAddEvent
    extends GwtEvent<ValueAddEventHandler> {
        public static GwtEvent.Type<ValueAddEventHandler> TYPE = new GwtEvent.Type();
        private String key;
        private String value;

        public ValueAddEvent(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public GwtEvent.Type<ValueAddEventHandler> getAssociatedType() {
            return TYPE;
        }

        protected void dispatch(ValueAddEventHandler handler) {
            handler.onValueAdd(this);
        }
    }

    static interface Binder
    extends UiBinder<Widget, MapEditor> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }

    static interface MapEditorStyle
    extends CssResource {
        public String errorPanelError();
    }
}

