/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets.slider.presenter;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.HasKeyDownHandlers;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.HasMouseMoveHandlers;
import com.google.gwt.event.dom.client.HasMouseOutHandlers;
import com.google.gwt.event.dom.client.HasMouseOverHandlers;
import com.google.gwt.event.dom.client.HasMouseUpHandlers;
import com.google.gwt.event.dom.client.HasMouseWheelHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.dashbuilder.common.client.widgets.slider.event.BarValueChangedEvent;
import org.dashbuilder.common.client.widgets.slider.event.BarValueChangedHandler;
import org.dashbuilder.common.client.widgets.slider.presenter.Display;
import org.dashbuilder.common.client.widgets.slider.presenter.SliderBarCalculator;
import org.dashbuilder.common.client.widgets.slider.view.Mark;

public class Presenter {
    protected String POINTER = "Pointer";
    protected String DEFAULT = "Default";
    protected HandlerManager handlerManager = new HandlerManager((Object)this);
    protected SliderBarCalculator sliderBarCalulator = new SliderBarCalculator();
    protected Display display;
    protected int maxValue;
    protected int touchPosition;
    protected boolean inDrag;
    protected int currentValue = 0;
    protected int lastFiredValue = -1;
    protected Orientation orientation;
    protected int minMarkStep = 10;

    public Presenter(Display display, Orientation orientation) {
        this.display = display;
        this.orientation = orientation;
    }

    public Presenter(Orientation orientation) {
        this(null, orientation);
    }

    public void setDislay(Display display) {
        this.display = display;
    }

    public HandlerRegistration addBarValueChangedHandler(BarValueChangedHandler barValueChangedHandler) {
        return this.handlerManager.addHandler(BarValueChangedEvent.TYPE, (EventHandler)barValueChangedHandler);
    }

    public void setMaxValue(int maxValue) {
        int n = maxValue = maxValue >= 0 ? maxValue : 0;
        if (maxValue == 0) {
            this.display.setDragVisible(false);
        } else {
            this.display.setDragVisible(true);
        }
        this.maxValue = maxValue;
        this.sliderBarCalulator.setMaxValue(maxValue);
    }

    public void setAbsMaxLength(int absMaxLength) {
        this.sliderBarCalulator.setAbsMaxLength(absMaxLength);
    }

    public void setBarPixelSize(int barPixelSize) {
        this.display.drawScrollBar(barPixelSize);
        this.sliderBarCalulator.setAbsMaxLength(this.display.getAbsMaxLength());
    }

    public void setValue(int value) {
        this.currentValue = value = this.checkValue(value);
        if (!this.display.isAttached()) {
            return;
        }
        int absPosition = this.sliderBarCalulator.clcAbsPositionByValue(value);
        this.setDragPosition(absPosition, true);
    }

    public void processParams() {
        if (this.maxValue == 0) {
            return;
        }
        this.sliderBarCalulator.processParams();
    }

    public int getValue() {
        return this.currentValue;
    }

    protected void onRootMouseWheel(MouseWheelEvent event) {
        this.increaseValue(event.getDeltaY());
    }

    protected void onRootKeyUpLeft() {
        this.increaseValue(-1);
    }

    protected void onRootKeyDownRight() {
        this.increaseValue(1);
    }

    protected void onDragMouseDown(MouseDownEvent event) {
        if (this.maxValue == 0) {
            return;
        }
        this.stopDefaultAndPropagationForEvent((DomEvent)event);
        DOM.setCapture((Element)this.display.getDragWidget().getElement());
        this.inDrag = true;
        this.touchPosition = this.display.getScaleTouchPosition((MouseEvent)event);
    }

    protected void onDragMouseUp(MouseUpEvent event) {
        if (this.maxValue == 0) {
            return;
        }
        this.inDrag = false;
        this.stopDefaultAndPropagationForEvent((DomEvent)event);
        DOM.releaseCapture((Element)this.display.getDragWidget().getElement());
        this.currentValue = this.sliderBarCalulator.clcValueByAbsPosition(this.display.getDragPosition());
        this.setDragPosition(this.sliderBarCalulator.clcAbsPositionByValue(this.currentValue), true);
    }

    protected void onDragMouseMove(MouseMoveEvent event) {
        if (this.maxValue == 0) {
            return;
        }
        event.preventDefault();
        if (!this.inDrag) {
            return;
        }
        int newTochPosition = this.display.getScaleTouchPosition((MouseEvent)event);
        this.setDragPosition(this.sliderBarCalulator.checkAbsPosition(this.display.getDragPosition() + newTochPosition - this.touchPosition), false);
        this.touchPosition = newTochPosition;
    }

    protected void onScaleMouseDown(MouseDownEvent event) {
        if (this.maxValue == 0) {
            return;
        }
        this.stopDefaultAndPropagationForEvent((DomEvent)event);
        this.currentValue = this.sliderBarCalulator.clcValueByAbsPosition(this.display.getScaleTouchPosition((MouseEvent)event));
        this.setDragPosition(this.sliderBarCalulator.clcAbsPositionByValue(this.currentValue), true);
    }

    protected void onRootMouseDown(MouseDownEvent event) {
        if (this.maxValue == 0) {
            return;
        }
        this.currentValue = this.sliderBarCalulator.clcValueByAbsPosition(this.display.getScaleTouchPosition((MouseEvent)event));
        this.setDragPosition(this.sliderBarCalulator.clcAbsPositionByValue(this.currentValue), true);
    }

    protected void onRootMouseOver(MouseOverEvent event) {
        if (this.maxValue == 0) {
            return;
        }
        this.setCursorType(this.POINTER);
        this.display.getRootWidget().getElement().focus();
    }

    protected void onRootMouseOut(MouseOutEvent event) {
        if (this.maxValue == 0) {
            return;
        }
        this.setCursorType(this.DEFAULT);
    }

    protected void onLessMouseDown(MouseDownEvent event) {
        if (this.maxValue == 0) {
            return;
        }
        this.stopDefaultAndPropagationForEvent((DomEvent)event);
        this.increaseValue(-1);
    }

    protected void onMoreMouseDown(MouseDownEvent event) {
        if (this.maxValue == 0) {
            return;
        }
        this.stopDefaultAndPropagationForEvent((DomEvent)event);
        this.increaseValue(1);
    }

    public void bind() {
        ArrayList<Widget> moreWidgets;
        ((HasMouseWheelHandlers)this.display.getRootWidget()).addMouseWheelHandler(new MouseWheelHandler(){

            public void onMouseWheel(MouseWheelEvent event) {
                event.preventDefault();
                Presenter.this.onRootMouseWheel(event);
            }
        });
        ((HasKeyDownHandlers)this.display.getRootWidget()).addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                int nativeKeyCode = event.getNativeKeyCode();
                if (Presenter.this.orientation == Orientation.VERTICAL) {
                    if (nativeKeyCode == 38) {
                        Presenter.this.onRootKeyUpLeft();
                    }
                    if (nativeKeyCode == 40) {
                        Presenter.this.onRootKeyDownRight();
                    }
                } else {
                    if (nativeKeyCode == 37) {
                        Presenter.this.onRootKeyUpLeft();
                    }
                    if (nativeKeyCode == 39) {
                        Presenter.this.onRootKeyDownRight();
                    }
                }
            }
        });
        ((HasMouseDownHandlers)this.display.getDragWidget()).addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                Presenter.this.onDragMouseDown(event);
            }
        });
        ((HasMouseMoveHandlers)this.display.getDragWidget()).addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                Presenter.this.onDragMouseMove(event);
            }
        });
        ((HasMouseUpHandlers)this.display.getDragWidget()).addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                Presenter.this.onDragMouseUp(event);
            }
        });
        ((HasMouseDownHandlers)this.display.getScaleWidget()).addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                Presenter.this.onScaleMouseDown(event);
            }
        });
        ((HasMouseDownHandlers)this.display.getRootWidget()).addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                Presenter.this.onRootMouseDown(event);
            }
        });
        ((HasMouseOverHandlers)this.display.getRootWidget()).addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                Presenter.this.onRootMouseOver(event);
            }
        });
        ((HasMouseOutHandlers)this.display.getRootWidget()).addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                Presenter.this.onRootMouseOut(event);
            }
        });
        ArrayList<Widget> lessWidgets = this.display.getLessWidgets();
        if (lessWidgets != null) {
            for (int i = 0; i < lessWidgets.size(); ++i) {
                ((HasMouseDownHandlers)lessWidgets.get(i)).addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        Presenter.this.onLessMouseDown(event);
                    }
                });
            }
        }
        if ((moreWidgets = this.display.getMoreWidgets()) != null) {
            for (int i = 0; i < moreWidgets.size(); ++i) {
                ((HasMouseDownHandlers)moreWidgets.get(i)).addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        Presenter.this.onMoreMouseDown(event);
                    }
                });
            }
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    protected int checkValue(int value) {
        value = value >= this.maxValue ? this.maxValue : value;
        value = value < 0 ? 0 : value;
        return value;
    }

    protected void increaseValue(int stepCount) {
        int nPosition;
        this.currentValue += stepCount;
        this.currentValue = this.checkValue(this.currentValue);
        int cDragPosition = this.display.getDragPosition();
        if (cDragPosition == (nPosition = this.sliderBarCalulator.clcAbsPositionByValue(this.currentValue))) {
            this.currentValue = this.sliderBarCalulator.clcValueByAbsPosition(nPosition += stepCount / Math.abs(stepCount));
        }
        this.setDragPosition(this.sliderBarCalulator.clcAbsPositionByValue(this.currentValue), true);
    }

    public void setDragPosition(int position, boolean fireEvent) {
        this.currentValue = this.sliderBarCalulator.clcValueByAbsPosition(position);
        this.display.setDragPosition(position);
        if (fireEvent && this.currentValue != this.lastFiredValue) {
            this.handlerManager.fireEvent((GwtEvent)new BarValueChangedEvent(this.currentValue));
        }
    }

    protected void stopDefaultAndPropagationForEvent(DomEvent event) {
        event.preventDefault();
        event.stopPropagation();
    }

    public void setCursorType(String cursorType) {
        DOM.setStyleAttribute((Element)this.display.getRootWidget().getElement(), (String)"cursor", (String)cursorType);
    }

    public void drawMarks(String color, int delimSize) {
        int markHeight;
        int markWidth;
        if (!this.isMarkAvailable()) {
            return;
        }
        if (this.orientation == Orientation.VERTICAL) {
            markWidth = delimSize;
            markHeight = 1;
        } else {
            markWidth = 1;
            markHeight = delimSize;
        }
        for (int i = 0; i <= this.maxValue; ++i) {
            Mark mark = new Mark(color, markWidth, markHeight);
            int markPosition = this.sliderBarCalulator.clcAbsPositionByValue(i);
            this.display.putMark(mark, markPosition);
        }
    }

    protected int getMarkStep() {
        return this.sliderBarCalulator.clcAbsPositionByValue(1) - this.sliderBarCalulator.clcAbsPositionByValue(0);
    }

    protected boolean isMarkAvailable() {
        int currentMarkStep = this.getMarkStep();
        return currentMarkStep >= this.minMarkStep && this.getMaxValue() != 0;
    }

    public void setMinMarkStep(int minMarkStep) {
        this.minMarkStep = minMarkStep;
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

