/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets.slider.view;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.MouseEvent;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.dashbuilder.common.client.widgets.slider.presenter.Presenter;
import org.dashbuilder.common.client.widgets.slider.view.Mark;
import org.dashbuilder.common.client.widgets.slider.view.SliderBar;

public class SliderBarHorizontal
extends SliderBar {
    protected int barWidth;
    protected int barHeight;
    protected int dragTopPosition;
    protected int scaleWidth;

    protected int getBarHeight() {
        this.barHeight = this.getH(this.drag.getElement());
        for (int i = 0; i < this.orderedWidgets.size(); ++i) {
            this.barHeight = this.orderedWidgets.get(i) == this.scale ? Math.max(this.barHeight, this.scaleSize) : Math.max(this.barHeight, this.getH(((Widget)this.orderedWidgets.get(i)).getElement()));
        }
        this.barHeight = Math.max(this.barHeight, this.scaleSize);
        return this.barHeight;
    }

    protected void ajustScaleSize(int widgetWidth) {
        int i;
        this.scaleWidth = widgetWidth;
        if (this.less != null) {
            for (i = 0; i < this.less.size(); ++i) {
                this.scaleWidth -= this.getW(((Widget)this.less.get(i)).getElement());
            }
        }
        if (this.more != null) {
            for (i = 0; i < this.more.size(); ++i) {
                this.scaleWidth -= this.getW(((Widget)this.more.get(i)).getElement());
            }
        }
        this.scale.setPixelSize(this.scaleWidth, this.scaleSize);
    }

    @Override
    public int getAbsMaxLength() {
        return this.scaleWidth - this.getW(this.drag.getElement());
    }

    @Override
    public void drawScrollBar(int barWidth) {
        this.absPanel.clear();
        this.putWidgetsToAbsPanel();
        this.initVariables(barWidth);
        this.ajustScaleSize(barWidth);
        this.setHeight(this.getBarHeight() + "px");
        this.absPanel.setPixelSize(barWidth, this.getBarHeight());
        this.placeWidgets(this.orderedWidgets);
        this.absPanel.setWidgetPosition(this.drag, this.getScaleLeft(this.orderedWidgets), this.dragTopPosition);
    }

    protected void initVariables(int barWidth) {
        this.barWidth = barWidth;
        this.startPosition = this.getScaleLeft(this.orderedWidgets);
        this.dragTopPosition = (this.getBarHeight() - this.getH(this.drag.getElement())) / 2;
    }

    protected int getScaleLeft(ArrayList<Widget> widgets) {
        int sPosition = 0;
        for (int i = 0; i < widgets.size(); ++i) {
            if (widgets.get(i) != this.scale) {
                sPosition += this.getW(widgets.get(i).getElement());
                continue;
            }
            return sPosition;
        }
        return sPosition;
    }

    protected void placeWidgets(ArrayList<Widget> widgets) {
        int tmpPosition = 0;
        int barHeight = this.getBarHeight();
        for (int i = 0; i < widgets.size(); ++i) {
            if (widgets.get(i) == this.scale) {
                this.absPanel.setWidgetPosition(widgets.get(i), tmpPosition, (barHeight - this.scaleSize) / 2);
            } else {
                this.absPanel.setWidgetPosition(widgets.get(i), tmpPosition, (barHeight - this.getH(widgets.get(i).getElement())) / 2);
            }
            tmpPosition += this.getW(widgets.get(i).getElement());
        }
    }

    @Override
    public void setDragPosition(int position) {
        position = this.startPosition + position;
        this.absPanel.setWidgetPosition(this.drag, position, this.dragTopPosition);
    }

    @Override
    public int getScaleTouchPosition(MouseEvent event) {
        return event.getRelativeX((Element)this.getElement()) - this.startPosition - this.getW(this.drag.getElement()) / 2;
    }

    @Override
    public int getDragPosition() {
        return this.absPanel.getWidgetLeft(this.drag) - this.startPosition;
    }

    @Override
    public void putMark(Mark mark, int markPosition) {
        int markY = (this.barHeight - mark.getMarkHeight()) / 2;
        this.absPanel.add((Widget)mark, this.startPosition + markPosition + this.getW(this.drag.getElement()) / 2, markY);
    }

    @Override
    public Presenter.Orientation getOrientation() {
        return Presenter.Orientation.HORIZONTAL;
    }

    public void setHeight(String height) {
        super.setHeight(this.getBarHeight() + "px");
    }

    public void setWidth(int width) {
        super.setWidth(width + "px");
        if (this.isAttached()) {
            this.presenter.setBarPixelSize(width);
            this.presenter.processParams();
            this.reDrawMarks();
            this.setValue(this.getValue());
        }
    }

    @Override
    public void setScaleWidget(Widget scaleWidget, int scaleHeight) {
        super.setScaleWidget(scaleWidget, scaleHeight);
    }
}

