/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets.slider.view;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.MouseEvent;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.dashbuilder.common.client.widgets.slider.presenter.Presenter;
import org.dashbuilder.common.client.widgets.slider.view.Mark;
import org.dashbuilder.common.client.widgets.slider.view.SliderBar;

public class SliderBarVertical
extends SliderBar {
    protected int barWidth;
    protected int barHeight;
    protected int dragLeftPosition;
    protected int scaleHeight;

    public SliderBarVertical(Presenter presenter) {
        super(presenter);
    }

    public SliderBarVertical() {
    }

    public int getBarWidth() {
        this.barWidth = this.getW(this.drag.getElement());
        for (int i = 0; i < this.orderedWidgets.size(); ++i) {
            this.barWidth = this.orderedWidgets.get(i) == this.scale ? Math.max(this.barWidth, this.scaleSize) : Math.max(this.barWidth, this.getW(((Widget)this.orderedWidgets.get(i)).getElement()));
        }
        this.barWidth = Math.max(this.barWidth, this.scaleSize);
        return this.barWidth;
    }

    public void ajustScaleSize(int widgetHeight) {
        int i;
        this.scaleHeight = widgetHeight;
        if (this.less != null) {
            for (i = 0; i < this.less.size(); ++i) {
                this.scaleHeight -= this.getH(((Widget)this.less.get(i)).getElement());
            }
        }
        if (this.more != null) {
            for (i = 0; i < this.more.size(); ++i) {
                this.scaleHeight -= this.getH(((Widget)this.more.get(i)).getElement());
            }
        }
        this.scale.setPixelSize(this.scaleSize, this.scaleHeight);
    }

    @Override
    public int getAbsMaxLength() {
        return this.scaleHeight - this.getH(this.drag.getElement());
    }

    @Override
    public void drawScrollBar(int barHeight) {
        this.absPanel.clear();
        this.putWidgetsToAbsPanel();
        this.initVariables(barHeight);
        this.ajustScaleSize(barHeight);
        this.setWidth(this.getBarWidth() + "px");
        this.absPanel.setPixelSize(this.getBarWidth(), barHeight);
        this.placeWidgets(this.orderedWidgets);
        this.absPanel.setWidgetPosition(this.drag, this.dragLeftPosition, this.getScaleTop(this.orderedWidgets));
    }

    protected void initVariables(int barHeight) {
        this.barHeight = barHeight;
        this.startPosition = this.getScaleTop(this.orderedWidgets);
        this.dragLeftPosition = (this.getBarWidth() - this.getW(this.drag.getElement())) / 2;
    }

    protected int getScaleTop(ArrayList<Widget> widgets) {
        int sPosition = 0;
        for (int i = 0; i < widgets.size(); ++i) {
            if (widgets.get(i) != this.scale) {
                sPosition += this.getH(widgets.get(i).getElement());
                continue;
            }
            return sPosition;
        }
        return sPosition;
    }

    protected void placeWidgets(ArrayList<Widget> widgets) {
        int tmpPosition = 0;
        int barWidth = this.getBarWidth();
        for (int i = 0; i < widgets.size(); ++i) {
            if (widgets.get(i) == this.scale) {
                this.absPanel.setWidgetPosition(widgets.get(i), (barWidth - this.scaleSize) / 2, tmpPosition);
            } else {
                this.absPanel.setWidgetPosition(widgets.get(i), (barWidth - this.getW(widgets.get(i).getElement())) / 2, tmpPosition);
            }
            tmpPosition += this.getH(widgets.get(i).getElement());
        }
    }

    @Override
    public void setDragPosition(int position) {
        position = this.startPosition + position;
        this.absPanel.setWidgetPosition(this.drag, this.dragLeftPosition, position);
    }

    @Override
    public int getScaleTouchPosition(MouseEvent event) {
        return event.getRelativeY((Element)this.getElement()) - this.startPosition - this.getH(this.drag.getElement()) / 2;
    }

    @Override
    public int getDragPosition() {
        return this.absPanel.getWidgetTop(this.drag) - this.startPosition;
    }

    @Override
    public void putMark(Mark mark, int markPosition) {
        int markX = (this.barWidth - mark.getMarkWidth()) / 2;
        this.absPanel.add((Widget)mark, markX, this.startPosition + markPosition + this.getH(this.drag.getElement()) / 2);
    }

    @Override
    public Presenter.Orientation getOrientation() {
        return Presenter.Orientation.VERTICAL;
    }

    public void setHeight(String height) {
        super.setHeight(height);
        if (this.isAttached()) {
            this.presenter.setBarPixelSize(this.getH(this.getElement()));
            this.presenter.processParams();
            this.reDrawMarks();
            this.setValue(this.getValue());
        }
    }

    public void setWidth(String width) {
        super.setWidth(this.getBarWidth() + "px");
    }

    @Override
    public void setScaleWidget(Widget scaleWidget, int scaleWidth) {
        super.setScaleWidget(scaleWidget, scaleWidth);
    }
}

