/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;

public class JsonSourceViewer
extends Composite {
    private static final String INDENT = "    ";
    public FlexTable table = new FlexTable();

    public JsonSourceViewer() {
        this.initWidget((Widget)this.table);
    }

    public void setContent(JSONObject jsonSource) {
        this.clearContent();
        String jsonSourceString = this.formatJsonObjectAsString(jsonSource, "");
        String[] rows = jsonSourceString.split("\n");
        for (int i = 0; i < rows.length; ++i) {
            String escaped = this.replaceLeadingWhitespaces(rows[i]);
            this.table.setHTML(i, 0, escaped);
        }
    }

    private String replaceLeadingWhitespaces(String text) {
        String s = text.trim();
        if (s.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (' ' == text.charAt(i)) {
            sb.append("&nbsp;");
            ++i;
        }
        sb.append(text.substring(i));
        return sb.toString();
    }

    private void clearContent() {
        this.table.removeAllRows();
    }

    private String formatJsonValueAsString(JSONValue jsonValue, String indent) {
        if (jsonValue == null) {
            return "";
        }
        if (jsonValue.isObject() != null) {
            return this.formatJsonObjectAsString(jsonValue.isObject(), indent);
        }
        if (jsonValue.isArray() != null) {
            return this.formatJsonArrayAsString(jsonValue.isArray(), indent);
        }
        if (jsonValue.isString() != null) {
            return "\"" + jsonValue.isString().stringValue() + "\"";
        }
        return jsonValue.toString();
    }

    private String formatJsonObjectAsString(JSONObject jsonObject, String indent) {
        if (jsonObject == null) {
            return "";
        }
        String newIndent = indent + INDENT;
        StringBuilder sb = new StringBuilder("{");
        String[] keys = jsonObject.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            sb.append("\n");
            sb.append(newIndent).append("\"").append(keys[i]).append("\"").append(": ");
            sb.append(newIndent).append(this.formatJsonValueAsString(jsonObject.get(keys[i]), newIndent));
            sb.append(i == keys.length - 1 ? "" : ",").append("\n");
        }
        sb.append(indent).append("}");
        return sb.toString();
    }

    private String formatJsonArrayAsString(JSONArray jsonArray, String indent) {
        if (jsonArray == null) {
            return "";
        }
        String newIndent = indent + INDENT;
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < jsonArray.size(); ++i) {
            sb.append("\n");
            sb.append(newIndent).append(this.formatJsonValueAsString(jsonArray.get(i), newIndent));
            sb.append(i == jsonArray.size() - 1 ? "\n" : ", ");
        }
        sb.append(indent).append("]");
        return sb.toString();
    }
}

