/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.HasOneWidget;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;

public class SlidingPanel
extends ResizeComposite
implements HasWidgets,
HasOneWidget {
    private final LayoutPanel layoutPanel = new LayoutPanel();
    private int currentIndex = -1;

    public SlidingPanel() {
        this.initWidget((Widget)this.layoutPanel);
    }

    public void add(IsWidget w) {
        this.add(w.asWidget());
    }

    public void add(Widget w) {
        this.layoutPanel.add(w);
        if (this.currentIndex < 0) {
            this.currentIndex = 0;
        } else {
            this.layoutPanel.setWidgetLeftWidth(w, 100.0, Style.Unit.PCT, 100.0, Style.Unit.PCT);
        }
    }

    public void clear() {
        this.setWidget((Widget)null);
    }

    public Widget getWidget() {
        return this.layoutPanel.getWidget(this.currentIndex);
    }

    public Iterator iterator() {
        return this.layoutPanel.iterator();
    }

    public boolean remove(Widget w) {
        return this.layoutPanel.remove(w);
    }

    public void setWidget(IsWidget w) {
        if (w != null) {
            this.setWidget(SlidingPanel.asWidgetOrNull((IsWidget)w));
        }
    }

    public void setWidget(Widget widget) {
        int newIndex = this.layoutPanel.getWidgetIndex(widget);
        if (newIndex < 0) {
            newIndex = this.layoutPanel.getWidgetCount();
            this.add(widget);
        }
        this.show(newIndex);
    }

    private void show(int newIndex) {
        if (newIndex == this.currentIndex) {
            return;
        }
        boolean fromLeft = newIndex < this.currentIndex;
        Widget current = this.layoutPanel.getWidget(this.currentIndex);
        Widget widget = this.layoutPanel.getWidget(newIndex);
        this.currentIndex = newIndex;
        this.layoutPanel.setWidgetLeftWidth(widget, 0.0, Style.Unit.PCT, 100.0, Style.Unit.PCT);
        if (fromLeft) {
            this.layoutPanel.setWidgetLeftWidth(current, 100.0, Style.Unit.PCT, 100.0, Style.Unit.PCT);
        } else {
            this.layoutPanel.setWidgetLeftWidth(current, -100.0, Style.Unit.PCT, 100.0, Style.Unit.PCT);
        }
        this.layoutPanel.animate(500);
    }
}

