/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.validation.editors;

import com.github.gwtbootstrap.client.ui.FileUpload;
import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.Tooltip;
import com.github.gwtbootstrap.client.ui.base.HasId;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.ui.client.adapters.HasTextEditor;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class FileUploadEditor
extends Composite
implements HasId,
HasText,
IsEditor<HasTextEditor>,
HasEditorErrors<String> {
    private static final String[] LOADING_IMAGE_SIZE = new String[]{"16px", "16px"};
    @UiField
    FileUploadEditorStyle style;
    @UiField
    FlowPanel mainPanel;
    @UiField
    FormPanel formPanel;
    @UiField
    Tooltip errorTooltip;
    @UiField(provided=true)
    @Editor.Ignore
    FileUpload fileUpload;
    @UiField
    @Editor.Ignore
    Label fileLabel;
    @UiField
    Image loadingImage;
    private String id;
    private String value;
    private HasTextEditor editor;
    private FileUploadEditorCallback callback;
    private SafeUri loadingImageUri;
    private final FormPanel.SubmitCompleteHandler formSubmitCompleteHandler = new FormPanel.SubmitCompleteHandler(){

        public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
            if (FileUploadEditor.this.loadingImage != null) {
                FileUploadEditor.this.fileUpload.setVisible(true);
                FileUploadEditor.this.loadingImage.setVisible(false);
            }
        }
    };
    private final ChangeHandler filePathChangeHandler = new ChangeHandler(){

        public void onChange(ChangeEvent event) {
            String _f = FileUploadEditor.this.callback.getUploadFileName();
            String _a = FileUploadEditor.this.callback.getUploadFileUrl();
            FileUploadEditor.this.setText(_f);
            FileUploadEditor.this.formPanel.setAction(_a);
            if (FileUploadEditor.this.loadingImage != null) {
                FileUploadEditor.this.fileUpload.setVisible(false);
                FileUploadEditor.this.loadingImage.setVisible(true);
            }
            FileUploadEditor.this.fileLabel.setVisible(false);
            FileUploadEditor.this.formPanel.submit();
        }
    };

    @UiConstructor
    public FileUploadEditor() {
        this.fileUpload = new FileUpload(){

            public void showErrors(List<EditorError> errors) {
                super.showErrors(errors);
                if (errors != null && !errors.isEmpty()) {
                    for (EditorError error : errors) {
                        if (error.getEditor() != this) continue;
                        error.setConsumed(false);
                    }
                }
            }

            protected void setErrorLabelText(String errorMessage) {
                FileUploadEditor.this.errorTooltip.setText(errorMessage);
                FileUploadEditor.this.errorTooltip.reconfigure();
            }
        };
        this.initWidget((Widget)Binder.BINDER.createAndBindUi((Object)this));
        this.fileUpload.setControlGroup((Widget)this.mainPanel);
        this.fileUpload.setErrorLabel(this.errorTooltip.asWidget());
        this.fileUpload.addChangeHandler(this.filePathChangeHandler);
        this.loadingImage.setVisible(false);
        this.formPanel.setEncoding("multipart/form-data");
        this.formPanel.setMethod("post");
        this.formPanel.setWidget((Widget)this.fileUpload);
        this.formPanel.addSubmitCompleteHandler(this.formSubmitCompleteHandler);
    }

    public HandlerRegistration addSubmitCompleteHandler(FormPanel.SubmitCompleteHandler submitCompleteHandler) {
        return this.formPanel.addSubmitCompleteHandler(submitCompleteHandler);
    }

    public void setLoadingImageUri(SafeUri loadingImageUri) {
        this.loadingImageUri = loadingImageUri;
        this.loadingImage.setUrl(loadingImageUri);
        this.loadingImage.setSize(LOADING_IMAGE_SIZE[0], LOADING_IMAGE_SIZE[1]);
    }

    public void setCallback(FileUploadEditorCallback callback) {
        this.callback = callback;
    }

    public void showErrors(List<EditorError> errors) {
        this.fileUpload.showErrors(errors);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.value;
    }

    public void setText(String text) {
        this.value = text;
        if (!this.isEmpty(this.fileUpload.asEditor().getValue())) {
            this.fileLabel.setVisible(false);
        } else if (!this.isEmpty(text)) {
            int slash;
            int n = slash = text.lastIndexOf("/") != -1 ? text.lastIndexOf("/") : text.lastIndexOf("\\");
            if (slash == -1) {
                this.fileLabel.setText(text);
            } else {
                this.fileLabel.setText(text.substring(slash + 1));
            }
            this.fileLabel.setVisible(true);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public HasTextEditor asEditor() {
        if (this.editor == null) {
            this.editor = HasTextEditor.of((HasText)this);
        }
        return this.editor;
    }

    public void clear() {
        this.formPanel.reset();
        this.setText(null);
        this.fileLabel.setVisible(false);
    }

    public static interface FileUploadEditorCallback {
        public String getUploadFileName();

        public String getUploadFileUrl();
    }

    static interface FileUploadEditorStyle
    extends CssResource {
    }

    static interface Binder
    extends UiBinder<Widget, FileUploadEditor> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

