/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.validation.editors;

import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.Popover;
import com.github.gwtbootstrap.client.ui.Tooltip;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasConstrainedValue;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ImageListEditor<T>
extends Composite
implements HasConstrainedValue<T>,
HasEditorErrors<T>,
IsEditor<TakesValueEditor<T>> {
    public static final int POPOVER_SHOW_DELAY = 1000;
    private static final double ALPHA_ICON_NOT_SELECTED = 0.2;
    private final List<T> values = new ArrayList<T>();
    private TakesValueEditor<T> editor;
    private final Map<T, Entry> entries = new LinkedHashMap<T, Entry>();
    private T value;
    private boolean isEditMode;
    private int width = -1;
    private int height = -1;
    private String imageStyle = null;
    @UiField
    ImageListEditorStyle style;
    @UiField
    HTMLPanel errorPanel;
    @UiField
    HorizontalPanel mainPanel;
    @UiField
    Tooltip errorTooltip;

    @UiConstructor
    public ImageListEditor() {
        this.initWidget((Widget)Binder.BINDER.createAndBindUi((Object)this));
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public TakesValueEditor<T> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of((TakesValue)this);
        }
        return this.editor;
    }

    public T getValue() {
        return this.value;
    }

    public void setAcceptableValues(Map<T, Entry> newValues) {
        this.values.clear();
        this.entries.clear();
        if (newValues != null) {
            for (Map.Entry<T, Entry> entry : newValues.entrySet()) {
                final T _value = entry.getKey();
                Entry _entry = entry.getValue();
                Image _image = _entry.image;
                if (this.width > 0 && this.height > 0) {
                    _image.setSize(this.width + "px", this.height + "px");
                }
                _image.addStyleName(this.style.imagePointer());
                if (this.imageStyle != null) {
                    _image.addStyleName(this.imageStyle);
                }
                _image.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (ImageListEditor.this.isEditMode) {
                            ImageListEditor.this.setValue(_value);
                        }
                    }
                });
                this.values.add(_value);
                String heading = _entry.heading;
                String text = _entry.text;
                if (heading != null && text != null) {
                    Popover popover = new Popover();
                    popover.setHeading(heading);
                    popover.setText(text);
                    popover.setWidget((Widget)_image);
                    popover.setShowDelay(1000);
                    this.mainPanel.add((IsWidget)popover);
                } else {
                    this.mainPanel.add((Widget)_image);
                }
                this.entries.put(_value, _entry);
            }
        }
    }

    public void setAcceptableValues(Collection<T> newValues) {
        this.values.clear();
        if (newValues != null) {
            for (T nextNewValue : newValues) {
                this.values.add(nextNewValue);
            }
        }
    }

    public void setValue(T value) {
        this.setValue(value, false);
    }

    public void setValue(T value, boolean fireEvents) {
        if (value == this.value) {
            for (T entry : this.values) {
                Image image = this.entries.get(entry).image;
                this.applyAlpha(image, 1.0);
            }
            return;
        }
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        this.disableError();
        T before = this.value;
        this.value = value;
        for (T entry : this.values) {
            Image image = this.entries.get(entry).image;
            if (entry.equals(value)) {
                this.applyAlpha(image, 1.0);
                continue;
            }
            this.applyAlpha(image, 0.2);
        }
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, before, value);
        }
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors = errors != null && !errors.isEmpty();
        String toolTipText = null;
        if (hasErrors) {
            StringBuilder sb = new StringBuilder();
            for (EditorError error : errors) {
                sb.append("\n").append(error.getMessage());
            }
            if (sb.length() > 0) {
                toolTipText = sb.substring(1);
            }
        }
        if (toolTipText != null) {
            this.enableError(toolTipText);
        } else {
            this.disableError();
        }
    }

    private void enableError(String text) {
        this.setTooltipText(text);
        this.markErrorPanel(true);
    }

    private void disableError() {
        this.setTooltipText(null);
        this.markErrorPanel(false);
    }

    public void setEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setImageStyle(String imageStyle) {
        this.imageStyle = imageStyle;
    }

    private void applyAlpha(Image image, double alpha) {
        image.getElement().setAttribute("style", "filter: alpha(opacity=5);opacity: " + alpha);
        if (this.width > 0 && this.height > 0) {
            image.setSize(this.width + "px", this.height + "px");
        }
    }

    public void clear() {
        this.setValue(null);
        this.disableError();
    }

    private void markErrorPanel(boolean error) {
        if (error) {
            this.errorPanel.addStyleName(this.style.errorPanelError());
        } else {
            this.errorPanel.removeStyleName(this.style.errorPanelError());
        }
    }

    private void setTooltipText(String text) {
        if (text == null || text.trim().length() == 0) {
            this.errorTooltip.setText("");
        } else {
            this.errorTooltip.setText(text);
        }
        this.errorTooltip.reconfigure();
    }

    public static final class Entry {
        Image image;
        String heading;
        String text;

        public Entry(Image image) {
            this.image = image;
        }

        public Entry(Image image, String heading, String text) {
            this.image = image;
            this.heading = heading;
            this.text = text;
        }
    }

    static interface ImageListEditorStyle
    extends CssResource {
        public String errorPanel();

        public String errorPanelError();

        public String imagePointer();
    }

    static interface Binder
    extends UiBinder<Widget, ImageListEditor> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

