/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.validation.editors;

import com.github.gwtbootstrap.client.ui.Tooltip;
import com.github.gwtbootstrap.client.ui.constants.Placement;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.ui.client.adapters.ValueBoxEditor;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class ValueBoxEditorDecorator<T>
extends Composite
implements HasValue<T>,
HasEditorErrors<T>,
IsEditor<ValueBoxEditor<T>> {
    private static final String STYLE_ERROR = " control-group error ";
    private T value;
    @UiField
    ValueBoxEditorDecoratorStyle style;
    @UiField
    SimplePanel contents;
    @UiField
    DivElement errorLabel;
    @UiField
    Tooltip errorTooltip;
    private ValueBoxEditor<T> editor;
    private ErrorLabelPosition errorLabelPosition = ErrorLabelPosition.TOOLTIP_TOP;

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.setValue(value, false);
    }

    public void setValue(T value, boolean fireEvents) {
        this.disableError();
        if (value == this.value || this.value != null && this.value.equals(value)) {
            return;
        }
        T before = this.value;
        this.value = value;
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, before, value);
        }
    }

    @UiConstructor
    public ValueBoxEditorDecorator() {
        this.initWidget((Widget)Binder.BINDER.createAndBindUi((Object)this));
    }

    public ValueBoxEditorDecorator(ValueBoxBase<T> widget, ValueBoxEditor<T> editor) {
        this();
        this.contents.add(widget);
        this.editor = editor;
        super.listenToValueBoxBaseChangeEvent(widget);
    }

    public ValueBoxEditor<T> asEditor() {
        return this.editor;
    }

    public void setEditor(ValueBoxEditor<T> editor) {
        this.editor = editor;
    }

    @UiChild(limit=1, tagname="valuebox")
    public void setValueBox(ValueBoxBase<T> widget) {
        this.contents.add(widget);
        this.listenToValueBoxBaseChangeEvent(widget);
        this.setEditor(widget.asEditor());
    }

    public void setEnabled(boolean enabled) {
        ((ValueBoxBase)this.contents.getWidget()).setEnabled(enabled);
    }

    private void listenToValueBoxBaseChangeEvent(ValueBoxBase<T> widget) {
        if (widget != null) {
            final Object before = widget.getValue();
            widget.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ValueBoxEditorDecorator.this.disableError();
                }
            });
            widget.addValueChangeHandler(new ValueChangeHandler<T>(){

                public void onValueChange(ValueChangeEvent<T> event) {
                    ValueBoxEditorDecorator.this.disableError();
                    ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)ValueBoxEditorDecorator.this, (Object)before, (Object)event.getValue());
                }
            });
        }
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors;
        StringBuilder sb = new StringBuilder();
        for (EditorError error : errors) {
            if (!error.getEditor().equals(this.editor)) continue;
            sb.append("\n").append(error.getMessage());
        }
        boolean bl = hasErrors = sb.length() > 0;
        if (!hasErrors) {
            this.disableError();
            return;
        }
        this.enableError(sb.substring(1));
    }

    private void enableError(String text) {
        this.contents.addStyleName(STYLE_ERROR);
        if (this.isUsingErrorLabel()) {
            this.setErrorLabelText(text);
            this.setTooltipText(null);
        } else {
            this.setErrorLabelText(null);
            this.setTooltipText(text);
        }
    }

    private void disableError() {
        this.contents.removeStyleName(STYLE_ERROR);
        this.setErrorLabelText(null);
        this.setTooltipText(null);
    }

    private void setTooltipText(String text) {
        if (text == null || text.trim().length() == 0) {
            this.errorTooltip.setText("");
        } else {
            this.errorTooltip.setText(text);
        }
        this.reconfigureTooltip();
    }

    private void setErrorLabelText(String text) {
        if (text == null || text.trim().length() == 0) {
            this.errorLabel.setInnerText("");
            this.errorLabel.getStyle().setDisplay(Style.Display.NONE);
        } else {
            this.errorLabel.setInnerText(text);
            this.errorLabel.getStyle().setDisplay(Style.Display.INLINE);
        }
    }

    private boolean isUsingErrorLabel() {
        return !this.isUsingErrorTooltip();
    }

    private boolean isUsingErrorTooltip() {
        return ErrorLabelPosition.TOOLTIP_TOP.equals((Object)this.getErrorLabelPosition()) || ErrorLabelPosition.TOOLTIP_BOTTOM.equals((Object)this.getErrorLabelPosition());
    }

    public ErrorLabelPosition getErrorLabelPosition() {
        return this.errorLabelPosition;
    }

    public void setErrorLabelPosition(ErrorLabelPosition errorLabelPosition) {
        this.errorLabelPosition = errorLabelPosition;
        this.positionErrorLabel();
    }

    private void positionErrorLabel() {
        switch (this.errorLabelPosition) {
            case TOOLTIP_TOP: {
                this.errorTooltip.setPlacement(Placement.TOP);
                this.reconfigureTooltip();
                break;
            }
            case TOOLTIP_BOTTOM: {
                this.errorTooltip.setPlacement(Placement.BOTTOM);
                this.reconfigureTooltip();
                break;
            }
            case LEFT: {
                this.errorLabel.addClassName(this.style.errorLabelLeft());
                break;
            }
            default: {
                this.errorLabel.addClassName(this.style.errorLabelRight());
            }
        }
    }

    private void reconfigureTooltip() {
        this.errorTooltip.reconfigure();
    }

    public void clear() {
        this.setValue(null);
        this.disableError();
    }

    public static enum ErrorLabelPosition {
        LEFT,
        RIGHT,
        TOOLTIP_TOP,
        TOOLTIP_BOTTOM;

    }

    static interface ValueBoxEditorDecoratorStyle
    extends CssResource {
        public String contents();

        public String errorLabel();

        public String errorLabelLeft();

        public String errorLabelRight();
    }

    static interface Binder
    extends UiBinder<Widget, ValueBoxEditorDecorator<?>> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

