/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets;

import com.github.gwtbootstrap.client.ui.Alert;
import com.github.gwtbootstrap.client.ui.event.ClosedEvent;
import com.github.gwtbootstrap.client.ui.event.ClosedHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.common.client.resources.i18n.DashbuilderCommonMessages;

public class TimeoutPopupPanel
extends PopupPanel {
    private Timer timer;
    private int duration;
    private FlowPanel mainPanel = new FlowPanel();
    private FlowPanel messagePanel = new FlowPanel();
    private FlowPanel timeoutPanel = new FlowPanel();

    public TimeoutPopupPanel() {
        this.init();
    }

    public TimeoutPopupPanel(boolean autoHide) {
        super(autoHide);
        this.init();
    }

    public TimeoutPopupPanel(boolean autoHide, boolean modal) {
        super(autoHide, modal);
        this.init();
    }

    private void init() {
        this.mainPanel.add((Widget)this.messagePanel);
        this.timeoutPanel.setVisible(false);
        this.mainPanel.add((Widget)this.timeoutPanel);
        super.add((Widget)this.mainPanel);
    }

    public void setTimeout(int duration) {
        this.duration = duration;
    }

    public void add(IsWidget child) {
        this.messagePanel.add(child);
    }

    public void add(Widget w) {
        this.messagePanel.add(w);
    }

    public boolean remove(IsWidget child) {
        return this.messagePanel.remove(child);
    }

    public boolean remove(Widget w) {
        return this.messagePanel.remove(w);
    }

    public void show() {
        if (this.duration == 0) {
            this.endTimer();
        }
        if (this.duration > 0) {
            this.startTimer();
        }
        this.messagePanel.setVisible(true);
        this.timeoutPanel.setVisible(false);
        super.show();
    }

    public void hide() {
        this.endTimer();
        super.hide();
    }

    public void hide(boolean autoClosed) {
        this.endTimer();
        super.hide(autoClosed);
    }

    public void cancel() {
        this.endTimer();
    }

    private void startTimer() {
        if (this.timer != null) {
            this.endTimer();
        }
        this.timer = new Timer(){

            public void run() {
                TimeoutPopupPanel.this.timeout();
            }
        };
        this.timer.schedule(this.duration);
    }

    private void endTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private Alert buildDefaultTimeoutPanel() {
        String d = this.getDurationInSeconds();
        String m = DashbuilderCommonMessages.INSTANCE.timeout(d);
        Alert alert = new Alert(m);
        alert.addClosedHandler(new ClosedHandler(){

            public void onClosed(ClosedEvent closedEvent) {
                TimeoutPopupPanel.this.hide();
            }
        });
        return alert;
    }

    private String getDurationInSeconds() {
        if (this.duration > 0) {
            float s = this.duration / 1000;
            return NumberFormat.getFormat((String)"#.0").format((double)s);
        }
        return "0";
    }

    private void timeout() {
        if (this.getHandlerCount(TimeoutFiredEvent.TYPE) == 0) {
            this.messagePanel.setVisible(false);
            this.timeoutPanel.setVisible(true);
            this.timeoutPanel.clear();
            Alert timeoutAlert = this.buildDefaultTimeoutPanel();
            this.timeoutPanel.add((Widget)timeoutAlert);
        }
    }

    public HandlerRegistration addTimeoutFiredEventHandler(TimeoutFiredEventHandler handler) {
        return this.addHandler(handler, TimeoutFiredEvent.TYPE);
    }

    public static interface TimeoutFiredEventHandler
    extends EventHandler {
        public void onTimeoutFired(TimeoutFiredEvent var1);
    }

    public static class TimeoutFiredEvent
    extends GwtEvent<TimeoutFiredEventHandler> {
        public static GwtEvent.Type<TimeoutFiredEventHandler> TYPE = new GwtEvent.Type();

        public GwtEvent.Type getAssociatedType() {
            return TYPE;
        }

        protected void dispatch(TimeoutFiredEventHandler handler) {
            handler.onTimeoutFired(this);
        }
    }
}

