/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets.slider.view;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.dashbuilder.common.client.widgets.slider.event.BarValueChangedHandler;
import org.dashbuilder.common.client.widgets.slider.exception.WidgetNotFoundError;
import org.dashbuilder.common.client.widgets.slider.presenter.Display;
import org.dashbuilder.common.client.widgets.slider.presenter.Presenter;
import org.dashbuilder.common.client.widgets.slider.view.Mark;
import org.dashbuilder.common.client.widgets.slider.view.TouchableAbsolutePanelPK;

public abstract class SliderBar
extends FocusPanel
implements Display {
    protected Widget scale;
    protected Widget drag;
    protected int scaleSize;
    protected int startPosition;
    protected int delimSize;
    protected ArrayList<Widget> less = new ArrayList();
    protected ArrayList<Widget> more = new ArrayList();
    protected ArrayList<Widget> orderedWidgets = new ArrayList();
    protected TouchableAbsolutePanelPK absPanel = new TouchableAbsolutePanelPK();
    protected boolean isMarksPlaced = false;
    protected boolean wasInited = false;
    protected String color;
    protected Presenter presenter;

    public SliderBar() {
        this.presenter = new Presenter(this, this.getOrientation());
        this.add((Widget)this.absPanel);
    }

    public SliderBar(Presenter presenter) {
        if (presenter == null) {
            this.presenter = new Presenter(this, this.getOrientation());
        } else {
            this.presenter = presenter;
            presenter.setDislay(this);
        }
        this.add((Widget)this.absPanel);
    }

    @Override
    public Widget getDragWidget() {
        return this.drag;
    }

    @Override
    public void setDragVisible(boolean isVisible) {
        if (this.drag != null) {
            this.drag.setVisible(isVisible);
        }
    }

    @Override
    public ArrayList<Widget> getLessWidgets() {
        return this.less;
    }

    @Override
    public ArrayList<Widget> getMoreWidgets() {
        return this.more;
    }

    @Override
    public Widget getScaleWidget() {
        return this.scale;
    }

    protected int getStartPosition() {
        return this.startPosition;
    }

    protected void setMoreWidget(Widget moreWidget) {
        this.orderedWidgets.add(moreWidget);
        this.more.add(moreWidget);
    }

    protected void setLessWidget(Widget lessWidget) {
        this.orderedWidgets.add(lessWidget);
        this.less.add(lessWidget);
    }

    protected void setDragWidget(Widget drag) {
        this.drag = drag;
    }

    protected void setScaleWidget(Widget scaleWidget, int scaleSize) {
        this.orderedWidgets.add(scaleWidget);
        this.scale = scaleWidget;
        this.scaleSize = scaleSize;
    }

    @Override
    public Widget getRootWidget() {
        return this;
    }

    public void setNotSelectedInFocus() {
        DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.getElement(), (String)"outline", (String)"0px");
    }

    public void drawMarks(String color, int delimSize) {
        if (!this.isMarksPlaced) {
            this.color = color;
            this.delimSize = delimSize;
            this.presenter.drawMarks(color, delimSize);
            this.isMarksPlaced = true;
        }
    }

    public void removeMarks() {
        int childCount = this.absPanel.getWidgetCount();
        for (int i = 0; i < childCount; ++i) {
            Widget widget = this.absPanel.getWidget(i);
            if (!(widget instanceof Mark)) continue;
            this.absPanel.remove(i);
            --childCount;
            --i;
        }
        this.isMarksPlaced = false;
    }

    public HandlerRegistration addBarValueChangedHandler(BarValueChangedHandler barValueChangedHandler) {
        return this.presenter.addBarValueChangedHandler(barValueChangedHandler);
    }

    public void setValue(int value) {
        this.presenter.setValue(value);
    }

    protected void prepare(int maxValue, int pixelSize) {
        this.drawScrollBar(pixelSize);
        this.presenter.setMaxValue(maxValue);
        this.presenter.setAbsMaxLength(this.getAbsMaxLength());
        this.presenter.processParams();
        this.presenter.setValue(this.getValue());
    }

    public int getMaxValue() {
        return this.presenter.getMaxValue();
    }

    public void setMaxValue(int maxValue) {
        this.presenter.setMaxValue(maxValue);
        this.presenter.processParams();
        try {
            if (this.isMarksPlaced) {
                this.removeMarks();
                this.drawMarks(this.color, this.delimSize);
            }
            this.setValue(this.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processParams() {
        this.presenter.processParams();
        if (this.isMarksPlaced) {
            this.isMarksPlaced = false;
            this.drawMarks(this.color, this.delimSize);
        }
    }

    public int getValue() {
        return this.presenter.getValue();
    }

    protected void onLoad() {
        super.onLoad();
        if (this.drag == null) {
            throw new WidgetNotFoundError("Drag widget not found...");
        }
        if (this.scale == null) {
            throw new WidgetNotFoundError("Scale widget not found...");
        }
        if (!this.wasInited) {
            this.presenter.bind();
            this.wasInited = true;
        }
        if (this.getOrientation() == Presenter.Orientation.HORIZONTAL) {
            this.prepare(this.presenter.getMaxValue(), this.getW(this.getElement()));
        } else {
            this.prepare(this.presenter.getMaxValue(), this.getH(this.getElement()));
        }
        this.reDrawMarks();
    }

    protected void reDrawMarks() {
        if (this.isMarksPlaced) {
            this.removeMarks();
            this.drawMarks(this.color, this.delimSize);
        }
    }

    protected void putWidgetsToAbsPanel() {
        for (int i = 0; i < this.orderedWidgets.size(); ++i) {
            this.absPanel.add(this.orderedWidgets.get(i));
        }
        this.absPanel.add(this.drag, 0, 0);
        DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.drag.getElement(), (String)"zIndex", (String)"500");
    }

    public void setMinMarkStep(int minMarkStep) {
        this.presenter.setMinMarkStep(minMarkStep);
    }

    protected int getW(Element element) {
        String w = DOM.getStyleAttribute((com.google.gwt.dom.client.Element)element, (String)"width");
        return this.parseSize(w);
    }

    protected int getH(Element element) {
        String h = DOM.getStyleAttribute((com.google.gwt.dom.client.Element)element, (String)"height");
        return this.parseSize(h);
    }

    protected int parseSize(String size) {
        if (size == null || size.trim().length() == 0) {
            return 0;
        }
        if (size.endsWith("px")) {
            return Integer.parseInt(size.substring(0, size.length() - 2));
        }
        return 0;
    }
}

