/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.gwtbootstrap3.client.ui.Popover;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.Placement;

@Dependent
public class ValueBoxEditorView<T>
extends Composite
implements ValueBoxEditor.View<T> {
    private static final String STYLE_ERROR = " control-group has-error ";
    @UiField
    SimplePanel contents;
    @UiField
    @Editor.Ignore
    Tooltip errorTooltip;
    ValueBoxEditor<T> presenter;
    ValueBoxBase<T> widget;

    public void init(ValueBoxEditor<T> presenter) {
        this.presenter = presenter;
    }

    @UiConstructor
    public ValueBoxEditorView() {
        this.initWidget((Widget)Binder.BINDER.createAndBindUi(this));
    }

    @Override
    public void setValueBox(ValueBoxBase<T> widget) {
        this.widget = widget;
        widget.addValueChangeHandler(new ValueChangeHandler<T>(){

            public void onValueChange(ValueChangeEvent<T> event) {
                ValueBoxEditorView.this.presenter.onValueChanged(event.getValue());
            }
        });
        this.contents.add(widget);
    }

    @Override
    public ValueBoxEditor.View<T> setValue(T value) {
        this.widget.setValue(value);
        return this;
    }

    @Override
    public ValueBoxEditor.View<T> showError(SafeHtml message) {
        this.contents.addStyleName(STYLE_ERROR);
        this.errorTooltip.setTitle(message.asString());
        this.errorTooltip.reconfigure();
        return this;
    }

    @Override
    public ValueBoxEditor.View<T> clearError() {
        this.contents.removeStyleName(STYLE_ERROR);
        this.errorTooltip.setTitle("");
        this.errorTooltip.reconfigure();
        return this;
    }

    @Override
    public ValueBoxEditor.View<T> addHelpContent(String title, String content, Placement placement) {
        Popover popover = new Popover(this.widget);
        popover.setContainer("body");
        popover.setShowDelayMs(1000);
        popover.setPlacement(placement);
        popover.setTitle(title);
        popover.setContent(content);
        this.contents.add((IsWidget)popover);
        return this;
    }

    static interface Binder
    extends UiBinder<Widget, ValueBoxEditorView> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

