/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.list;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.event.Event;
import junit.framework.Assert;
import org.dashbuilder.common.client.editor.list.DropDownEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;

@RunWith(value=MockitoJUnitRunner.class)
public class DropDownEditorTest {
    @Mock
    DropDownEditor.View view;
    @Mock
    LiveSearchDropDown liveSearchDropDown;
    @Mock
    Event<ValueChangeEvent<String>> valueChangeEvent;
    DropDownEditor presenter;
    Collection<DropDownEditor.Entry> entries = new ArrayList<DropDownEditor.Entry>();

    @Before
    public void setup() {
        this.presenter = new DropDownEditor(this.view, this.liveSearchDropDown, this.valueChangeEvent);
        this.entries.add(this.presenter.newEntry("entry1", "Entry 1"));
        this.entries.add(this.presenter.newEntry("entry2", "Entry 2"));
        this.presenter.setEntries(this.entries);
        this.presenter.init();
    }

    @Test
    public void testInit() {
        ((LiveSearchDropDown)Mockito.verify((Object)this.liveSearchDropDown)).setSearchEnabled(false);
        ((LiveSearchDropDown)Mockito.verify((Object)this.liveSearchDropDown)).setSearchService((LiveSearchService)Mockito.any());
        Assert.assertNull((Object)this.presenter.getValue());
    }

    @Test
    public void testEntries() {
        this.presenter.getDropDownEntries("", -1, itemList -> {
            Assert.assertEquals((int)itemList.size(), (int)2);
            Assert.assertEquals((String)((String)itemList.get(0)), (String)"Entry 1");
            Assert.assertEquals((String)((String)itemList.get(1)), (String)"Entry 2");
        });
    }

    @Test
    public void testSelect() {
        Mockito.when((Object)this.liveSearchDropDown.getSelectedItem()).thenReturn((Object)"Entry 1");
        this.presenter.setValue("entry2");
        this.presenter.onEntrySelected();
        ArgumentCaptor ac = ArgumentCaptor.forClass(ValueChangeEvent.class);
        ((Event)Mockito.verify(this.valueChangeEvent)).fire(ac.capture());
        Assert.assertEquals((String)this.presenter.getValue(), (String)"entry1");
        ValueChangeEvent event = (ValueChangeEvent)ac.getValue();
        Assert.assertEquals((Object)event.getValue(), (Object)"entry1");
        Assert.assertEquals((Object)event.getOldValue(), (Object)"entry2");
    }

    @Test
    public void testSetValue() {
        this.presenter.setValue("entry2");
        ((LiveSearchDropDown)Mockito.verify((Object)this.liveSearchDropDown)).setSelectedItem("Entry 2");
        Assert.assertEquals((String)this.presenter.getValue(), (String)"entry2");
        this.presenter.setSelectHint("- select - ");
        this.presenter.setValue(null);
        ((LiveSearchDropDown)Mockito.verify((Object)this.liveSearchDropDown)).setSelectedItem("- select - ");
        Assert.assertNull((Object)this.presenter.getValue());
        Mockito.reset((Object[])new LiveSearchDropDown[]{this.liveSearchDropDown});
        this.presenter.clear();
        this.presenter.setValue("entry2");
        this.presenter.setEntries(this.entries);
        ((LiveSearchDropDown)Mockito.verify((Object)this.liveSearchDropDown)).setSelectedItem("Entry 2");
        Mockito.reset((Object[])new LiveSearchDropDown[]{this.liveSearchDropDown});
        this.presenter.clear();
        this.presenter.setEntries(this.entries);
        ((LiveSearchDropDown)Mockito.verify((Object)this.liveSearchDropDown, (VerificationMode)Mockito.never())).setSelectedItem(Mockito.anyString());
    }

    @Test
    public void testClear() {
        this.presenter.setValue("entry2");
        this.presenter.clear();
        ((LiveSearchDropDown)Mockito.verify((Object)this.liveSearchDropDown)).clear();
        Assert.assertNull((Object)this.presenter.getValue());
    }
}

