/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.list;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeUri;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dashbuilder.common.client.editor.AbstractEditorTest;
import org.dashbuilder.common.client.editor.list.ImageListEditor;
import org.dashbuilder.common.client.editor.list.ImageListEditorView;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.dashbuilder.dataprovider.BeanProviderType;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.SQLProviderType;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Assert;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

public abstract class ImageListEditorTest
extends AbstractEditorTest {
    @Mock
    EventSourceMock<ValueChangeEvent<DataSetProviderType>> valueChangeEvent;
    protected final Collection<DataSetProviderType> expectedTypes = new ArrayList<DataSetProviderType>(4);
    protected final List<ImageListEditor.Entry> expectedEntries = new ArrayList<ImageListEditor.Entry>(4);
    protected ImageListEditor<DataSetProviderType> presenter;
    protected ImageListEditorView<DataSetProviderType> view;

    public void initExpectedValues() {
        this.expectedTypes.add((DataSetProviderType)DataSetProviderType.BEAN);
        this.expectedTypes.add((DataSetProviderType)DataSetProviderType.CSV);
        this.expectedTypes.add((DataSetProviderType)DataSetProviderType.SQL);
        this.expectedTypes.add((DataSetProviderType)DataSetProviderType.ELASTICSEARCH);
        this.expectedEntries.addAll(this.mockEntries());
    }

    public void testClear() throws Exception {
        this.presenter.entries.addAll(this.expectedEntries);
        this.presenter.value = DataSetProviderType.BEAN;
        this.presenter.clear();
        junit.framework.Assert.assertTrue((boolean)this.presenter.entries.isEmpty());
        Assert.assertNull((Object)this.presenter.value);
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(Matchers.any(ImageListEditor.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).add((SafeUri)Matchers.any(SafeUri.class), Matchers.anyString(), Matchers.anyString(), (SafeHtml)Matchers.any(SafeHtml.class), (SafeHtml)Matchers.any(SafeHtml.class), Mockito.anyBoolean(), (Command)Matchers.any(Command.class));
    }

    public void testInit() throws Exception {
        this.presenter.init();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).init(this.presenter);
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).add((SafeUri)Matchers.any(SafeUri.class), Matchers.anyString(), Matchers.anyString(), (SafeHtml)Matchers.any(SafeHtml.class), (SafeHtml)Matchers.any(SafeHtml.class), Mockito.anyBoolean(), (Command)Matchers.any(Command.class));
    }

    public void testNewEntry() throws Exception {
        ImageListEditor.Entry expectedEntry = ImageListEditorTest.mockEntry((DataSetProviderType)DataSetProviderType.BEAN);
        ImageListEditor.Entry actualEntry = this.presenter.newEntry(expectedEntry.getValue(), expectedEntry.getUri(), expectedEntry.getHeading(), expectedEntry.getText());
        Assert.assertEquals((Object)expectedEntry.getHeading(), (Object)actualEntry.getHeading());
        Assert.assertEquals((Object)expectedEntry.getText(), (Object)actualEntry.getText());
        Assert.assertEquals((Object)expectedEntry.getUri(), (Object)actualEntry.getUri());
        Assert.assertEquals((Object)expectedEntry.getValue(), (Object)actualEntry.getValue());
    }

    public void testSetEntries() throws Exception {
        this.presenter.setEntries(this.expectedEntries);
        this.assertShowElements();
    }

    public void testClearErrors() throws Exception {
        ArrayList errors = new ArrayList();
        this.presenter.showErrors(errors);
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(Matchers.any(ImageListEditor.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).clearError();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).add((SafeUri)Matchers.any(SafeUri.class), Matchers.anyString(), Matchers.anyString(), (SafeHtml)Matchers.any(SafeHtml.class), (SafeHtml)Matchers.any(SafeHtml.class), Mockito.anyBoolean(), (Command)Matchers.any(Command.class));
    }

    public void testShowErrors() throws Exception {
        EditorError e1 = this.mockEditorError((Editor<?>)this.presenter, "m1");
        EditorError e2 = this.mockEditorError((Editor<?>)this.presenter, "m2");
        ArrayList<EditorError> errors = new ArrayList<EditorError>(2);
        errors.add(e1);
        errors.add(e2);
        this.presenter.showErrors(errors);
        ArgumentCaptor errorSafeHtmlCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(Matchers.any(ImageListEditor.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).add((SafeUri)Matchers.any(SafeUri.class), Matchers.anyString(), Matchers.anyString(), (SafeHtml)Matchers.any(SafeHtml.class), (SafeHtml)Matchers.any(SafeHtml.class), Mockito.anyBoolean(), (Command)Matchers.any(Command.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).showError((SafeHtml)errorSafeHtmlCaptor.capture());
        SafeHtml value = (SafeHtml)errorSafeHtmlCaptor.getValue();
        Assert.assertEquals((Object)"m1\nm2", (Object)value.asString());
    }

    public void testAddHelpContent() throws Exception {
        String title = "title";
        String content = "content";
        Placement p = Placement.BOTTOM;
        this.presenter.addHelpContent("title", "content", p);
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).addHelpContent("title", "content", p);
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(this.presenter);
    }

    public void testSetValueWithoutEvents() throws Exception {
        BeanProviderType value = DataSetProviderType.BEAN;
        this.presenter.entries.addAll(this.expectedEntries);
        this.presenter.setValue((Object)value, false);
        Assert.assertEquals((Object)value, (Object)this.presenter.value);
        this.assertShowElements();
    }

    public void testSetValueWithEvents() throws Exception {
        SQLProviderType oldValue = DataSetProviderType.SQL;
        BeanProviderType newValue = DataSetProviderType.BEAN;
        this.presenter.value = oldValue;
        this.presenter.entries.addAll(this.expectedEntries);
        this.presenter.setValue((Object)newValue, true);
        Assert.assertEquals((Object)newValue, (Object)this.presenter.value);
        this.assertShowElements();
        ((EventSourceMock)Mockito.verify(this.valueChangeEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ValueChangeEvent.class));
    }

    protected void assertShowElements() {
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(Matchers.any(ImageListEditor.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ImageListEditorView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)4))).add((SafeUri)Matchers.any(SafeUri.class), Matchers.anyString(), Matchers.anyString(), (SafeHtml)Matchers.any(SafeHtml.class), (SafeHtml)Matchers.any(SafeHtml.class), Mockito.anyBoolean(), (Command)Matchers.any(Command.class));
        Assert.assertEquals(this.expectedEntries, (Object)this.presenter.entries);
    }

    protected List<ImageListEditor.Entry> mockEntries() {
        ArrayList<ImageListEditor.Entry> result = new ArrayList<ImageListEditor.Entry>(4);
        result.add(ImageListEditorTest.mockEntry((DataSetProviderType)DataSetProviderType.BEAN));
        result.add(ImageListEditorTest.mockEntry((DataSetProviderType)DataSetProviderType.CSV));
        result.add(ImageListEditorTest.mockEntry((DataSetProviderType)DataSetProviderType.SQL));
        result.add(ImageListEditorTest.mockEntry((DataSetProviderType)DataSetProviderType.ELASTICSEARCH));
        return result;
    }

    protected static ImageListEditor.Entry mockEntry(DataSetProviderType type) {
        String name = type.getName();
        SafeUri uri = (SafeUri)Mockito.mock(SafeUri.class);
        SafeHtml safeHtml = (SafeHtml)Mockito.mock(SafeHtml.class);
        ((SafeHtml)Mockito.doReturn((Object)name).when((Object)safeHtml)).asString();
        ImageListEditor.Entry entry = (ImageListEditor.Entry)Mockito.mock(ImageListEditor.Entry.class);
        ((ImageListEditor.Entry)Mockito.doReturn((Object)type).when((Object)entry)).getValue();
        ((ImageListEditor.Entry)Mockito.doReturn((Object)safeHtml).when((Object)entry)).getHeading();
        ((ImageListEditor.Entry)Mockito.doReturn((Object)safeHtml).when((Object)entry)).getText();
        ((ImageListEditor.Entry)Mockito.doReturn((Object)uri).when((Object)entry)).getUri();
        return entry;
    }
}

