/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.file;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.common.client.editor.file.FileUploadEditor;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.ext.widgets.common.client.common.FileUpload;
import org.uberfire.mvp.Command;

@Dependent
public class FileUploadEditorView
extends Composite
implements FileUploadEditor.View {
    private static final String STYLE_ERROR = " control-group has-error ";
    @UiField
    @Editor.Ignore
    FlowPanel mainPanel;
    @UiField
    @Editor.Ignore
    FormPanel formPanel;
    @UiField
    @Editor.Ignore
    Tooltip errorTooltip;
    @UiField(provided=true)
    @Editor.Ignore
    FileUpload fileUpload = this.createFileUpload();
    @UiField
    @Editor.Ignore
    Label fileLabel;
    @UiField
    Icon loadingIcon;
    FileUploadEditor presenter;

    public void init(FileUploadEditor presenter) {
        this.presenter = presenter;
    }

    @UiConstructor
    public FileUploadEditorView() {
        this.initWidget((Widget)Binder.BINDER.createAndBindUi(this));
        this.initFormPanel();
    }

    private FileUpload createFileUpload() {
        return new FileUpload(new Command(){

            public void execute() {
                FileUploadEditorView.this.presenter.fileUploadHandler();
            }
        }, true);
    }

    private void initFormPanel() {
        this.formPanel.setEncoding("multipart/form-data");
        this.formPanel.setMethod("post");
        this.formPanel.setWidget((Widget)this.fileUpload);
        this.formPanel.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                boolean isFireEvent = FileUploadEditorView.this.presenter.onSubmit();
                if (!isFireEvent) {
                    event.cancel();
                }
            }
        });
        this.formPanel.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                FileUploadEditorView.this.presenter.onSubmitComplete(event.getResults());
            }
        });
    }

    @Override
    public FileUploadEditor.View addHelpContent(String title, String content, Placement placement) {
        Tooltip tooltip = new Tooltip((Widget)this.fileUpload);
        tooltip.setContainer("body");
        tooltip.setShowDelayMs(1000);
        tooltip.setPlacement(placement);
        tooltip.setTitle(content);
        this.formPanel.add((IsWidget)tooltip);
        return this;
    }

    @Override
    public FileUploadEditor.View setFileUploadName(String name) {
        this.fileUpload.setName(name);
        return this;
    }

    @Override
    public FileUploadEditor.View setFileUploadVisible(boolean visible) {
        this.fileUpload.setVisible(visible);
        return this;
    }

    @Override
    public FileUploadEditor.View setFileLabelText(String text) {
        this.fileLabel.setText(text);
        return this;
    }

    @Override
    public FileUploadEditor.View setFileLabelVisible(boolean visible) {
        this.fileLabel.setVisible(visible);
        return this;
    }

    @Override
    public FileUploadEditor.View setLoadingImageVisible(boolean visible) {
        this.loadingIcon.setVisible(visible);
        return this;
    }

    @Override
    public String getFileName() {
        return this.fileUpload.getFilename();
    }

    @Override
    public FileUploadEditor.View setFormAction(String action) {
        this.formPanel.setAction(action);
        return this;
    }

    @Override
    public FileUploadEditor.View submit() {
        this.formPanel.submit();
        return this;
    }

    @Override
    public FileUploadEditor.View showError(SafeHtml message) {
        this.mainPanel.addStyleName(STYLE_ERROR);
        this.errorTooltip.setTitle(message.asString());
        return this;
    }

    @Override
    public FileUploadEditor.View clearError() {
        this.mainPanel.removeStyleName(STYLE_ERROR);
        this.errorTooltip.setTitle("");
        return this;
    }

    static interface Binder
    extends UiBinder<Widget, FileUploadEditorView> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

