/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.common.client.editor.list.DropDownImageListEditor;
import org.dashbuilder.common.client.editor.list.ImageListEditor;
import org.dashbuilder.common.client.editor.list.ImageListEditorView;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.DropDown;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.mvp.Command;

@Dependent
public class DropDownImageListEditorView<T>
extends Composite
implements DropDownImageListEditor.View<T> {
    @UiField
    DropDownImageListEditorViewStyle style;
    @UiField
    @Editor.Ignore
    HTMLPanel errorPanel;
    @UiField
    @Editor.Ignore
    FlowPanel helpPanel;
    @UiField
    @Editor.Ignore
    DropDown dropDown;
    @UiField
    @Editor.Ignore
    Anchor dropDownAnchor;
    @UiField
    @Editor.Ignore
    DropDownMenu dropDownMenu;
    @UiField
    @Editor.Ignore
    Tooltip errorTooltip;
    @Editor.Ignore
    Image currentTypeImage;
    @Editor.Ignore
    InlineLabel caret;
    Tooltip currentTypeImageTooltip;
    ImageListEditor<T> presenter;

    public void init(ImageListEditor<T> presenter) {
        this.presenter = presenter;
    }

    @UiConstructor
    public DropDownImageListEditorView() {
        this.initWidget((Widget)Binder.BINDER.createAndBindUi(this));
        this.currentTypeImage = new Image();
        this.caret = new InlineLabel();
        this.caret.addStyleName("caret");
        this.caret.setVisible(true);
        this.dropDownAnchor.add((Widget)this.currentTypeImage);
        this.dropDownAnchor.add((Widget)this.caret);
        this.dropDownAnchor.setEnabled(true);
        this.currentTypeImageTooltip = new Tooltip((Widget)this.dropDown);
        this.currentTypeImageTooltip.setContainer("body");
        this.currentTypeImageTooltip.setShowDelayMs(100);
        this.currentTypeImage.addClickHandler(e -> this.currentTypeImageTooltip.hide());
        this.caret.addClickHandler(e -> this.currentTypeImageTooltip.hide());
        this.helpPanel.add((IsWidget)this.currentTypeImageTooltip);
    }

    @Override
    public ImageListEditorView<T> add(SafeUri uri, String width, String height, SafeHtml heading, SafeHtml text, boolean selected, Command clickCommand) {
        if (selected) {
            this.currentTypeImage.setUrl(uri);
            this.currentTypeImage.setSize(width, height);
        } else {
            Tooltip tooltip = new Tooltip();
            tooltip.setTitle(text.asString());
            tooltip.setContainer("body");
            tooltip.setPlacement(Placement.RIGHT);
            tooltip.setShowDelayMs(100);
            Image image = new Image(uri);
            image.setWidth(width);
            image.setHeight(height);
            image.addStyleName(this.style.image());
            image.addClickHandler(e -> {
                tooltip.hide();
                clickCommand.execute();
            });
            tooltip.setWidget((Widget)image);
            this.dropDownMenu.add((Widget)image);
        }
        return this;
    }

    @Override
    public ImageListEditorView<T> setHelpContent(String title, String content, Placement placement) {
        this.currentTypeImageTooltip.setPlacement(placement);
        this.currentTypeImageTooltip.setTitle(content);
        this.currentTypeImageTooltip.hide();
        return this;
    }

    @Override
    public ImageListEditorView<T> showError(SafeHtml message) {
        this.errorTooltip.setTitle(message.asString());
        this.errorPanel.removeStyleName(this.style.errorPanel());
        this.errorPanel.addStyleName(this.style.errorPanelWithError());
        return this;
    }

    @Override
    public ImageListEditorView<T> clearError() {
        this.errorTooltip.setTitle("");
        this.errorPanel.removeStyleName(this.style.errorPanelWithError());
        this.errorPanel.addStyleName(this.style.errorPanel());
        return this;
    }

    @Override
    public ImageListEditorView<T> clear() {
        this.clearError();
        this.dropDownMenu.clear();
        return this;
    }

    @Override
    public void setDropDown(boolean isDropDown) {
        this.dropDownAnchor.setEnabled(isDropDown);
        this.caret.setVisible(isDropDown);
    }

    static interface DropDownImageListEditorViewStyle
    extends CssResource {
        public String errorPanel();

        public String errorPanelWithError();

        public String image();
    }

    static interface Binder
    extends UiBinder<Widget, DropDownImageListEditorView> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

