/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.dashbuilder.common.client.widgets.FilterLabel;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

public class FilterLabelSet
implements IsElement {
    private View view;
    private SyncBeanManager beanManager;
    private Command onClearAllCommand;
    private int numberOfLabels = 0;

    @Inject
    public FilterLabelSet(View view, SyncBeanManager beanManager) {
        this.view = view;
        this.beanManager = beanManager;
        this.view.init(this);
        this.view.setClearAllEnabled(false);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void clear() {
        this.view.clearAll();
        this.view.setClearAllEnabled(false);
        this.numberOfLabels = 0;
    }

    public FilterLabel addLabel(String label) {
        FilterLabel filterLabel = (FilterLabel)this.beanManager.lookupBean(FilterLabel.class, new Annotation[0]).newInstance();
        filterLabel.setLabel(label);
        this.view.addLabel(filterLabel);
        ++this.numberOfLabels;
        this.view.setClearAllEnabled(this.numberOfLabels > 1);
        return filterLabel;
    }

    public void setOnClearAllCommand(Command onClearAllCommand) {
        this.onClearAllCommand = onClearAllCommand;
    }

    void onClearAll() {
        this.clear();
        if (this.onClearAllCommand != null) {
            this.onClearAllCommand.execute();
        }
    }

    public static interface View
    extends UberElement<FilterLabelSet> {
        public void clearAll();

        public void setClearAllEnabled(boolean var1);

        public void addLabel(FilterLabel var1);
    }
}

