/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client;

import java.util.Set;
import org.dashbuilder.common.client.StringTemplateBuilder;
import org.junit.Assert;
import org.junit.Test;

public class StringTemplateBuilderTest {
    @Test
    public void testNoReplacement() {
        StringTemplateBuilder templateBuilder = new StringTemplateBuilder();
        templateBuilder.setTemplate("Hello ${user} from ${place}.");
        Set keys = templateBuilder.keys();
        String code = templateBuilder.build();
        Assert.assertEquals((long)keys.size(), (long)2L);
        Assert.assertTrue((boolean)keys.contains("user"));
        Assert.assertTrue((boolean)keys.contains("place"));
        Assert.assertEquals((Object)code, (Object)"Hello ${user} from ${place}.");
    }

    @Test
    public void testReplacement() {
        StringTemplateBuilder templateBuilder = new StringTemplateBuilder();
        templateBuilder.setTemplate("Hello ${user} from ${place}.");
        templateBuilder.replace("user", "Mark");
        templateBuilder.replace("place", "London");
        String code = templateBuilder.build();
        Assert.assertEquals((Object)code, (Object)"Hello Mark from London.");
    }

    @Test
    public void testCustomKeys() {
        StringTemplateBuilder templateBuilder = new StringTemplateBuilder();
        templateBuilder.setKeyPrefix("[");
        templateBuilder.setKeySufix("]");
        templateBuilder.setTemplate("Hello [user] from [place].");
        templateBuilder.replace("user", "Mark");
        templateBuilder.replace("place", "London");
        String code = templateBuilder.build();
        Assert.assertEquals((Object)code, (Object)"Hello Mark from London.");
    }
}

